/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.captcha;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shieldcommunity.nullcordx.config.FrameSizes;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.FrameSizesSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class PickCaptchaSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new FrameSizesSerializer()).build();
    @Transient
    public static final PickCaptchaSettings IMP = new PickCaptchaSettings();
    public PICK_CAPTCHA PICK_CAPTCHA = new PICK_CAPTCHA();
    public long CONFIG_VERSION = 1L;

    public PickCaptchaSettings() {
        super(Paths.get("NullCordX/captcha/pick-captcha.yml", new String[0]), CONFIG);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PickCaptchaSettings)) {
            return false;
        }
        PickCaptchaSettings other = (PickCaptchaSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.CONFIG_VERSION != other.CONFIG_VERSION) {
            return false;
        }
        PICK_CAPTCHA this$PICK_CAPTCHA = this.PICK_CAPTCHA;
        PICK_CAPTCHA other$PICK_CAPTCHA = other.PICK_CAPTCHA;
        return !(this$PICK_CAPTCHA == null ? other$PICK_CAPTCHA != null : !((Object)this$PICK_CAPTCHA).equals(other$PICK_CAPTCHA));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PickCaptchaSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.CONFIG_VERSION;
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        PICK_CAPTCHA $PICK_CAPTCHA = this.PICK_CAPTCHA;
        result = result * 59 + ($PICK_CAPTCHA == null ? 43 : ((Object)$PICK_CAPTCHA).hashCode());
        return result;
    }

    @Comment(value={@CommentValue(value="Configuration for pick captcha")})
    public static class PICK_CAPTCHA {
        @Comment(value={@CommentValue(value="How many pick captcha images to generate. A large number can take up a lot of RAM."), @CommentValue(value="If network_compression_threshold is -1 or the packet compression level is too low, the pick captcha can take up a lot of RAM."), @CommentValue(value="A large number of pick captcha is more difficult for an attacker to remember to solve on their own.")})
        public int IMAGES_COUNT = 500;
        @NewLine
        @Comment(value={@CommentValue(value="Directory leading to groups of all images."), @CommentValue(value="All directories within this directory will be treated as groups and their contents will be scanned for an image."), @CommentValue(value="The name of the group directory should be named after the abstract objects in the image that are inside."), @CommentValue(value="The generator will scan and load any image within groups, their name doesn't matter."), @CommentValue(value="You can create for example the following directories inside IMAGES_GROUPS_PATH directory: 'pick_captcha/cats', 'pick_captcha/dogs', 'pick_captcha/lego'."), @CommentValue(value="Each directory will be considered a separate group and each must contain images.")})
        public String IMAGES_GROUPS_PATH = "pick_captcha";
        public IMAGE_SOURCES IMAGE_SOURCES = new IMAGE_SOURCES();
        @NewLine
        @Comment(value={@CommentValue(value="How many maximum random groups will be used for generation?")})
        public int MAX_GROUPS_PER_CAPTCHA = 4;
        @NewLine
        @Comment(value={@CommentValue(value="What is the maximum row for an image?")})
        public int MAX_IMAGE_ROW = 2;
        @NewLine
        @Comment(value={@CommentValue(value="What is the maximum column for an image?")})
        public int MAX_IMAGE_COLUMN = 2;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for post renders layers."), @CommentValue, @CommentValue(value="Same as render-layers-group, except that all specified layers will be applied to the rendered image after all groups have been merged."), @CommentValue(value="Useful if you need to overlay ripple or dithering on the finished image and not on each group separately."), @CommentValue(value="Disabled if empty.")})
        public String POST_RENDER = "ripple-less>Dithering>Mirror>rotation-chance";
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for frame sizes."), @CommentValue, @CommentValue(value="What specific frame sizes should the generator generate?"), @CommentValue(value="You can specify exact frame sizes, such as 2x2 or 3x3, and the generator will use a random size from those specified."), @CommentValue(value="Also, you can specify as many frames as you like and any size, including any arbitrary size, but please note that there must be a delimiter between the numbers as the 'x' symbol"), @CommentValue(value="For example: 2x2 or 3x2 or 4x4. Please note that the first number is the row of the frame, the second number is its column.")})
        public FrameSizes FRAME_SIZES = new FrameSizes(Arrays.asList("2x2", "2x3", "3x2", "3x3", "3x4", "4x3", "4x4"));

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PICK_CAPTCHA)) {
                return false;
            }
            PICK_CAPTCHA other = (PICK_CAPTCHA)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.IMAGES_COUNT != other.IMAGES_COUNT) {
                return false;
            }
            if (this.MAX_GROUPS_PER_CAPTCHA != other.MAX_GROUPS_PER_CAPTCHA) {
                return false;
            }
            if (this.MAX_IMAGE_ROW != other.MAX_IMAGE_ROW) {
                return false;
            }
            if (this.MAX_IMAGE_COLUMN != other.MAX_IMAGE_COLUMN) {
                return false;
            }
            String this$IMAGES_GROUPS_PATH = this.IMAGES_GROUPS_PATH;
            String other$IMAGES_GROUPS_PATH = other.IMAGES_GROUPS_PATH;
            if (this$IMAGES_GROUPS_PATH == null ? other$IMAGES_GROUPS_PATH != null : !this$IMAGES_GROUPS_PATH.equals(other$IMAGES_GROUPS_PATH)) {
                return false;
            }
            String this$POST_RENDER = this.POST_RENDER;
            String other$POST_RENDER = other.POST_RENDER;
            if (this$POST_RENDER == null ? other$POST_RENDER != null : !this$POST_RENDER.equals(other$POST_RENDER)) {
                return false;
            }
            FrameSizes this$FRAME_SIZES = this.FRAME_SIZES;
            FrameSizes other$FRAME_SIZES = other.FRAME_SIZES;
            return !(this$FRAME_SIZES == null ? other$FRAME_SIZES != null : !((Object)this$FRAME_SIZES).equals(other$FRAME_SIZES));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PICK_CAPTCHA;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.IMAGES_COUNT;
            result = result * 59 + this.MAX_GROUPS_PER_CAPTCHA;
            result = result * 59 + this.MAX_IMAGE_ROW;
            result = result * 59 + this.MAX_IMAGE_COLUMN;
            String $IMAGES_GROUPS_PATH = this.IMAGES_GROUPS_PATH;
            result = result * 59 + ($IMAGES_GROUPS_PATH == null ? 43 : $IMAGES_GROUPS_PATH.hashCode());
            String $POST_RENDER = this.POST_RENDER;
            result = result * 59 + ($POST_RENDER == null ? 43 : $POST_RENDER.hashCode());
            FrameSizes $FRAME_SIZES = this.FRAME_SIZES;
            result = result * 59 + ($FRAME_SIZES == null ? 43 : ((Object)$FRAME_SIZES).hashCode());
            return result;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for images sources")})
        public static class IMAGE_SOURCES {
            @Comment(value={@CommentValue(value="How many concurrent connections can the generator make to connect to services?")})
            public int THREAD_POOL = 4;
            @NewLine
            @Comment(value={@CommentValue(value="How long will downloaded images be cached in milliseconds?")})
            public long MAX_CACHE_TIME = 3600000L;
            public SERVICES SERVICES = new SERVICES();

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for services")})
            public static class SERVICES {
                public API_NINJAS API_NINJAS = new API_NINJAS();

                @Comment(value={@CommentValue(value="Configuration for api-ninjas.com service")})
                public static class API_NINJAS {
                    @Comment(value={@CommentValue(value="Should the generator use this service?"), @CommentValue(value="Please note that this service currently stores a limited number of images, most likely they may be repeated or are not random/unique.")})
                    public boolean ENABLED = false;
                    @NewLine
                    @Comment(value={@CommentValue(value="API license key")})
                    public String LICENSE = "key";
                    @NewLine
                    @Comment(value={@CommentValue(value="How long does one request to the service take before breaking the connection?")})
                    public int TIMEOUT = 5000;
                    @NewLine
                    @Comment(value={@CommentValue(value="What categories of images should be downloaded?"), @CommentValue(value="This service currently supports the following categories:"), @CommentValue(value="'nature, city, technology, food, still_life, abstract, wildlife'")})
                    @CollectionType(value=ArrayList.class)
                    public List<String> GROUPS = Arrays.asList("city", "food");
                    @NewLine
                    @Comment(value={@CommentValue(value="How many images should the generator download for each group?")})
                    public int IMAGES_PER_GROUP = 250;
                }
            }
        }
    }
}

