/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.migration.configs.config;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.config.IpAddresses;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.IpAddressesSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class ConfigSettingsV1
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new IpAddressesSerializer()).setLogMissingFields(false).build();
    @Transient
    public static final String PREFIX = "\u00a79\u00a7lNull\u00a7b\u00a7lCord\u00a7f\u00a7lX";
    @Transient
    public static final String PREFIX_MODERN = "<blue><bold>Null<aqua><bold>Cord<white><bold>X<reset>";
    @Comment(value={@CommentValue(value="For running the proxy, a license is needed (Provided on website)"), @CommentValue, @CommentValue(value="If you want to report issues, report them on the official discord: https://discord.shieldcommunity.net")})
    public String YOUR_LICENSE = "YOUR-LICENSE";
    public LANGUAGE LANGUAGE = new LANGUAGE();
    public PERFORMANCE PERFORMANCE = new PERFORMANCE();
    public PROTECTION PROTECTION = new PROTECTION();
    public GEYSER_DETECTION GEYSER_DETECTION = new GEYSER_DETECTION();
    public MODULES MODULES = new MODULES();
    public LOGS LOGS = new LOGS();
    public DYNAMIC_DNS DYNAMIC_DNS = new DYNAMIC_DNS();
    @NewLine
    @Comment(value={@CommentValue(value="List of game protocols you want to disable."), @CommentValue(value="All available protocol list: https://minecraft.fandom.com/wiki/Protocol_version"), @CommentValue(value="You can specify the version ranges you want to disable. For example 47-753 (disable versions from 1.8 to 1.16.3)")})
    @CollectionType(value=ArrayList.class)
    public List<String> DISABLED_PROTOCOLS = Collections.emptyList();
    @NewLine
    @Comment(value={@CommentValue(value="Online counter multiplier. The initial online value is multiplied by this number.")})
    public double ONLINE_BOOSTER = 1.0;
    @NewLine
    @Comment(value={@CommentValue(value="Some servers are sending titles that do not disappear, Should we reset it? (This only works on 1.19/1.20x)")})
    public boolean RESET_TITLE_ON_UPSTREAM = false;
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy try to send a player to specified server (first) in the server priority?")})
    public boolean LOBBY_KICK_REDIRECT_OVERRIDE = false;
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy hide connection error messages to the player?"), @CommentValue(value="Instead, a message will always be written stating that an error has occurred in your connection.")})
    public boolean HIDE_EXCEPTION_ON_CONNECTION_ERROR = false;
    @NewLine
    @Comment(value={@CommentValue(value="Option to modify the server icon name."), @CommentValue(value="Note that if you have cached custom motd enabled in motd.yml, this setting has no effect and you need to specify the path to the favicon in that file.")})
    public String SERVER_ICON_NAME = "server-icon.png";
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy enforce offline uuid for licensed accounts?"), @CommentValue(value="Enable if you want exactly the same behavior as in BotFilter.")})
    public boolean ALWAYS_APPLY_OFFLINE_UUID = false;
    @NewLine
    @Comment(value={@CommentValue(value="How long should a session cache last in seconds for the query?")})
    public int QUERY_SESSION_CACHE_TIME = 30;
    public long CONFIG_VERSION = 1L;

    public ConfigSettingsV1() {
        super(Paths.get("NullCordX/config.yml", new String[0]), CONFIG);
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for language")})
    public static class LANGUAGE {
        @Comment(value={@CommentValue(value="What language to use by default?"), @CommentValue(value="The specified language will be used in cases where it is not possible to determine the client's language."), @CommentValue(value="The language name must be according to the language code: http://www.lingoes.net/en/translator/langcode.htm"), @CommentValue(value="Default supported languages: en_us, es_es, ru_ru")})
        public String DEFAULT_TRANSLATION = "en_us";
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy use translation based on client settings?"), @CommentValue(value="If enabled, the proxy will try to send translation messages to the player according to their settings in the client."), @CommentValue(value="If a translation is not available, the default translation will be used."), @CommentValue(value="If disabled, the proxy will always use the default translation.")})
        public boolean DEPEND_ON_CLIENT_SETTINGS = true;
    }

    @NewLine
    @Comment(value={@CommentValue(value="You can improve the performance of the proxy by touching these aspects")})
    public static class PERFORMANCE {
        @Comment(value={@CommentValue(value="Disable calling the ConnectionInitEvent added by Waterfall."), @CommentValue(value="In large attacks, this event can potentially affect the performance of the proxy."), @CommentValue(value="You must turn this setting off if you have a plugin that depends on this event.")})
        public boolean DISABLE_CONNECTION_INIT_EVENT = true;
        @NewLine
        @Comment(value={@CommentValue(value="Disable calling the ClientConnectionEvent event. Can increase performance on large attacks."), @CommentValue(value="You must turn this setting off if you have a plugin that depends on this event.")})
        public boolean DISABLE_CLIENT_CONNECTION_EVENT = false;
        @NewLine
        @Comment(value={@CommentValue(value="Disable calling the PlayerHandshakeEvent event. Can increase performance on large attacks."), @CommentValue(value="You must turn this setting off if you have a plugin that depends on this event.")})
        public boolean DISABLE_PLAYER_HANDSHAKE_EVENT = false;
        @NewLine
        @Comment(value={@CommentValue(value="Disable calling the UserFailedCheckEvent event. May slightly improve performance during large bot attacks.")})
        public boolean DISABLE_USER_FAILED_CHECK_EVENT = false;
        @NewLine
        @Comment(value={@CommentValue(value="How the proxy will compress packets?"), @CommentValue(value="Higher values will use more CPU load (from level 1 - 9)"), @CommentValue(value="Keep this option by default if you don't know what are you doing.")})
        public int COMPRESSION_LEVEL = 6;
        @NewLine
        @Comment(value={@CommentValue(value="If enabled, the proxy will write cached packets such as captchas to direct memory."), @CommentValue(value="This can improve performance during bot attacks, however this memory is allocated outside the heap memory which means it will ignore the xms and xmx settings."), @CommentValue(value="If disabled, packets will always be cached in heap memory.")})
        public boolean CACHE_PACKETS_IN_DIRECT_MEMORY = true;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy use PooledByteBufAllocator for cached packets?"), @CommentValue(value="Using a pool can increase the speed of generating cached packets, but it also increases memory consumption."), @CommentValue(value="Disable this option if cached packets take up a lot of memory.")})
        public boolean USE_POOLED_BYTE_BUF_ALLOCATOR_FOR_CACHED_PACKETS = true;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy cache the decoder and encoder?"), @CommentValue(value="If there are plugins that change the decoder and encoder, you must disable this.")})
        public boolean CACHE_DECODER_AND_ENCODER_HANDLERS = true;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy slice the buffer instead of copying them?"), @CommentValue(value="May slightly increase performance when decoding large packets."), @CommentValue(value="Please note that this function only works if entity rewriting is disabled in the waterfall.yml config."), @CommentValue(value="If there is a plugin that modifies the buffer, you should disable this option.")})
        public boolean SLICE_INSTEAD_OF_COPY = true;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy enable the new ConsolidationFlush of netty?")})
        public boolean CONSOLIDATE_FLUSHES = true;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for tcp fast open")})
        public TCP_FAST_OPEN TCP_FAST_OPEN = new TCP_FAST_OPEN();

        public static class TCP_FAST_OPEN {
            public LISTENER LISTENER = new LISTENER();
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy support TFO when opening a connection to the backend server?")})
            public boolean DOWNSTREAM_ENABLED = true;

            @Comment(value={@CommentValue(value="Configuration for incoming connections")})
            public static class LISTENER {
                @Comment(value={@CommentValue(value="Should the proxy support TFO when listening incoming connection?")})
                public boolean ENABLED = false;
                @NewLine
                @Comment(value={@CommentValue(value="How many maximum number of outstanding (waiting to be accepted) TFO connections should be?")})
                public int MAX_CONNECTIONS = 3;
            }
        }
    }

    @NewLine
    @Comment(value={@CommentValue(value="General protection settings")})
    public static class PROTECTION {
        public SPAM_ATTACK_DETECTION SPAM_ATTACK_DETECTION = new SPAM_ATTACK_DETECTION();
        public BLACKLIST BLACKLIST = new BLACKLIST();
        public ANTIEXPLOIT ANTIEXPLOIT = new ANTIEXPLOIT();
        public TIMEOUT_INIT_CONNECTION TIMEOUT_INIT_CONNECTION = new TIMEOUT_INIT_CONNECTION();

        @Comment(value={@CommentValue(value="Configuration for spam attack detection")})
        public static class SPAM_ATTACK_DETECTION {
            @Comment(value={@CommentValue(value="This function turns on the attack mode if more than this value is connected in a certain time."), @CommentValue(value="This depends on your server traffic, you must increase it while players amount.")})
            public int SPAM_THRESHOLD = 500;
            @NewLine
            @Comment(value={@CommentValue(value="How long should it take before checking if the server is under attack in order to reset the spam counter or continue to consider the server under attack. In milliseconds 1 sec = 1000")})
            public int SPAM_THRESHOLD_TIME = 60000;
            @NewLine
            @Comment(value={@CommentValue(value="How long is the protection active? In milliseconds 1 sec = 1000")})
            public int SPAM_PROTECTION_TIME = 300000;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for blacklist"), @CommentValue, @CommentValue(value="Allows you to block players when trying to establish a connection to the server at the very beginning of the connection")})
        public static class BLACKLIST {
            @Comment(value={@CommentValue(value="Should the proxy use ip blacklist?")})
            public boolean ENABLED = true;
            @NewLine
            @Comment(value={@CommentValue(value="How long will keep the blacklisted IP address in seconds.")})
            public int MAX_TIME = 60;
            @NewLine
            @Comment(value={@CommentValue(value="What IP addresses should not be blacklisted?")})
            public IpAddresses NO_BLACKLIST = new IpAddresses(Arrays.asList("127.0.0.1/24", "172.18.0.1/24"));
            public EXTERNAL EXTERNAL = new EXTERNAL();
            public PROXY_LIST PROXY_LIST = new PROXY_LIST();

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for external blacklist")})
            public static class EXTERNAL {
                @Comment(value={@CommentValue(value="Should the proxy use an external blacklist?"), @CommentValue(value="If enabled, the proxy will execute commands on behalf of the user which can be used to block an IP address."), @CommentValue(value="This can be useful if you are using ipset."), @CommentValue(value="Be careful, if for some reason the proxy blocks your connection you will stop sending any kind of traffic including the whole system.")})
                public boolean ENABLED = false;
                @NewLine
                @Comment(value={@CommentValue(value="How many commands can be executed at the same time?"), @CommentValue(value="A large number can cause a huge load on the system.")})
                public int THREAD_POOL_SIZE = 1;
                @NewLine
                @Comment(value={@CommentValue(value="These commands are called when the blacklist has just been loaded."), @CommentValue(value="Usually this should be removing the old blacklist and creating a new one."), @CommentValue, @CommentValue(value="Placeholders:"), @CommentValue(value="%max_time% - maximum blacklist time")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_LOAD_EXECUTE = Arrays.asList("iptables -D INPUT -p tcp -m set --match-set nullcordx_blacklist src DROP", "ipset flush nullcordx_blacklist", "ipset destroy nullcordx_blacklist", "ipset create nullcordx_blacklist hash:ip timeout %max_time%", "iptables -I INPUT -p tcp -m set --match-set nullcordx_blacklist src -j DROP");
                @NewLine
                @Comment(value={@CommentValue(value="These commands are called when the proxy adds an IP address to the blacklist."), @CommentValue, @CommentValue(value="Placeholders:"), @CommentValue(value="%address% - blacklisted ip address")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_BLACKLIST_EXECUTE = Collections.singletonList("ipset add nullcordx_blacklist %address%");
                @NewLine
                @Comment(value={@CommentValue(value="These commands are called when the proxy removes an IP address from the blacklist."), @CommentValue, @CommentValue(value="Placeholders:"), @CommentValue(value="%address% - unblacklisted ip address")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_UNBLACKLIST_EXECUTE = Collections.singletonList("ipset del nullcordx_blacklist %address%");
                @NewLine
                @Comment(value={@CommentValue(value="These commands are called when the proxy clears the entire blacklist (usually via the command).")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_UNBLACKLIST_ALL_EXECUTE = Collections.singletonList("ipset flush nullcordx_blacklist");
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for proxy list")})
            public static class PROXY_LIST {
                @Comment(value={@CommentValue(value="Should the proxy download the proxy blacklist and then use it to block and in what cases should it be done?"), @CommentValue(value="-1 - Disabled"), @CommentValue(value="0 - Always"), @CommentValue(value="1 - Only when any type of attack is detected"), @CommentValue(value="2 - Just in a bot attack"), @CommentValue(value="3 - Just in a spam attack")})
                public int MODE = 1;
                @NewLine
                @Comment(value={@CommentValue(value="List of urls with known proxies."), @CommentValue(value="The web server should return an empty html page where there is only a list of addresses in the form of IP:PORT or just IP."), @CommentValue(value="You can use the file protocol to access files directly from the current host. Example: \"file:///home/proxy/nullcordx/proxylist.txt\"")})
                @CollectionType(value=ArrayList.class)
                public List<String> LIST = Arrays.asList("https://shieldcommunity.net/sockets.txt", "https://raw.githubusercontent.com/TheSpeedX/PROXY-List/master/socks4.txt", "https://raw.githubusercontent.com/ShiftyTR/Proxy-List/master/socks4.txt", "https://raw.githubusercontent.com/monosans/proxy-list/main/proxies/socks4.txt", "https://raw.githubusercontent.com/jetkai/proxy-list/main/online-proxies/txt/proxies-socks4.txt", "https://raw.githubusercontent.com/rdavydov/proxy-list/main/proxies/socks4.txt", "https://raw.githubusercontent.com/jetkai/proxy-list/main/online-proxies/txt/proxies-socks4.txt", "https://tcpshield.com/blocklist.txt");
                @NewLine
                @Comment(value={@CommentValue(value="How often in seconds to update the proxy list. 0 - to disable.")})
                public int UPDATE_TIME = 21600;
                @NewLine
                @Comment(value={@CommentValue(value="How long to wait for a connection to a url to download a list in milliseconds?")})
                public int CONNECTION_TIMEOUT = 10000;
                @NewLine
                @Comment(value={@CommentValue(value="How many concurrent connections to urls should be made at once?")})
                public int THREAD_POOL_SIZE = 8;
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for protocol verifications")})
        public static class ANTIEXPLOIT {
            public INITIAL_HANDLER_EXCEPTION_BLACKLIST INITIAL_HANDLER_EXCEPTION_BLACKLIST = new INITIAL_HANDLER_EXCEPTION_BLACKLIST();
            @NewLine
            @Comment(value={@CommentValue(value="How big a packet can a client send?")})
            public int MAX_BYTES = 25780;
            @NewLine
            @Comment(value={@CommentValue(value="How many packets the player can send per second?")})
            public int MAX_PACKETS_PER_SECOND = 600;
            @NewLine
            @Comment(value={@CommentValue(value="What is the maximum size of all sent packets per second?")})
            public int MAX_PACKET_BYTES_PER_SECOND = 65536;
            @NewLine
            @Comment(value={@CommentValue(value="What number of readable packets should be the limit? It is recommended to leave it in default")})
            public int MAX_READABLE_BYTES = 0x200000;
            @NewLine
            @Comment(value={@CommentValue(value="What should be the maximum buffer length after the decoder result?")})
            public int MAX_BUFFER_DECODER_LENGTH = 10;
            @NewLine
            @Comment(value={@CommentValue(value="How many chat messages and commands the player can send during these seconds? -1 - to disable.")})
            public int MAX_CHAT_MESSAGES_PER_SECOND = 5;
            @NewLine
            @Comment(value={@CommentValue(value="What should be the maximum string for names on Login request")})
            public int MAX_PROTOCOL_LOGIN_NAME_LENGTH = 16;

            @Comment(value={@CommentValue(value="Configuration for exceptions")})
            public static class INITIAL_HANDLER_EXCEPTION_BLACKLIST {
                @Comment(value={@CommentValue(value="Which list mode to use?"), @CommentValue(value="If enabled, the player will not be blacklisted when these exceptions occur."), @CommentValue(value="If disabled, the player will be blacklisted when these exceptions occur.")})
                public boolean WHITELIST = true;
                @NewLine
                @Comment(value={@CommentValue(value="List of exceptions."), @CommentValue(value="The list must contain the full name of the class. For example java.lang.IllegalStateException")})
                @CollectionType(value=ArrayList.class)
                public List<String> EXCEPTION_LIST = Arrays.asList("io.netty.handler.timeout.ReadTimeoutException", "io.netty.channel.unix.Errors$NativeIoException");
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for timeout init connection")})
        public static class TIMEOUT_INIT_CONNECTION {
            @Comment(value={@CommentValue(value="Should the proxy change the timeout of incoming connections?"), @CommentValue(value="Can help in situations where an attacker attacks with connections that do nothing for a long time."), @CommentValue(value="This will not affect players who are already on the server and who have successfully connected to the server."), @CommentValue(value="-1 - Disabled"), @CommentValue(value="0 - Always"), @CommentValue(value="1 - Just in a spam attack")})
            public int MODE = 1;
            @NewLine
            @Comment(value={@CommentValue(value="What will be the timeout for incoming connections? In milliseconds."), @CommentValue(value="Don't make it too low otherwise some players who are far away from the server won't be able to connect.")})
            public int TIMEOUT = 1000;
        }
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for geyser detection")})
    public static class GEYSER_DETECTION {
        @Comment(value={@CommentValue(value="List of IP addresses that belong to the geyser standalone server."), @CommentValue(value="Used to define a connection as a geyser connection if floodgate was not installed on the proxy.")})
        public IpAddresses GEYSER_STANDALONE_IPS = new IpAddresses(Collections.emptyList());
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for BungeeCord modules")})
    public static class MODULES {
        public boolean ENABLE_ALERT = true;
        public boolean ENABLE_FIND = true;
        public boolean ENABLE_KICK = true;
        public boolean ENABLE_LIST = true;
        public boolean ENABLE_SEND = true;
        public boolean ENABLE_SERVER = true;
        public RECONNECT RECONNECT = new RECONNECT();

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for reconnect module")})
        public static class RECONNECT {
            public boolean ENABLE = false;
            @NewLine
            @Comment(value={@CommentValue(value="What data format to use for storage?"), @CommentValue(value="Available: JSON and YAML")})
            public String TYPE = "YAML";
        }
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for logs")})
    public static class LOGS {
        @Comment(value={@CommentValue(value="Should the proxy print logs about connection initialization and closing?"), @CommentValue(value="Often these are logs of switching between servers.")})
        public boolean PRINT_HANDLER_BOSS_ACTIVE_INACTIVE = true;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy log handler boss exceptions? This is good to keep disabled if is not for debug")})
        public boolean PRINT_HANDLER_BOSS_EXCEPTIONS = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy log ping exceptions from ping handler?")})
        public boolean PRINT_PING_HANDLER_EXCEPTIONS = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy log server connecting exception?")})
        public boolean PRINT_SERVER_CONNECTING_EXCEPTIONS = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy show full stacktraces when they are usually shortened or not shown?"), @CommentValue(value="Warning! This will give a lot of technical information and can decrease performance on attack!")})
        public boolean PRINT_FULL_STACKTRACES = false;
        @NewLine
        @Comment(value={@CommentValue(value="Enables debug mode which shows some technical messages from NullCordX")})
        public boolean PRINT_NULLCORDX_DEBUG = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the proxy set the debug level to the logger? This will give a huge amount of logs, including logs from netty and from some libraries")})
        public boolean SET_DEBUG_LEVEL = false;
        @NewLine
        @Comment(value={@CommentValue(value="If enabled, the proxy will turn off all of the above settings when an attack is detected."), @CommentValue(value="When the attack is over, the proxy will turn on all the values above."), @CommentValue(value="Can be useful for debugging in a situation where you are constantly under attack.")})
        public boolean ALWAYS_ENABLED_UNTIL_SPAM_ATTACK = false;
        public ANTIBOT ANTIBOT = new ANTIBOT();

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for antibot logs")})
        public static class ANTIBOT {
            @Comment(value={@CommentValue(value="Should the proxy log into console the antibot messages?")})
            public boolean ENABLED = true;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy hide antibot messages if a bot attack is detected?")})
            public boolean HIDE_ON_BOT_ATTACK = true;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy hide antibot messages if a spam attack is detected?")})
            public boolean HIDE_ON_SPAM_ATTACK = true;
        }
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for dynamic dns")})
    public static class DYNAMIC_DNS {
        @Comment(value={@CommentValue(value="Should the proxy from time to time check the relevance of the IP address by extracting it from the dns server?"), @CommentValue(value="This function is usually useful if a domain is used as the IP address of the server.")})
        public boolean ENABLED = false;
        @NewLine
        @Comment(value={@CommentValue(value="How often to check dns? In milliseconds")})
        public int CHECK_COOLDOWN = 60000;
    }
}

