/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.database;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.shieldcommunity.nullcordx.database.Database;

public class DatabaseSQLite
implements Database {
    private Connection connection;
    private ExecutorService executor;
    private static final String DB_PATH = "JDBC:sqlite:NullCordX/database.db";

    @Override
    public String getName() {
        return "SQLite";
    }

    @Override
    public void start() throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-SQLite-%d").setPriority(3).build());
        }
        if (this.connection == null) {
            this.connection = DriverManager.getConnection(DB_PATH);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public boolean needCloseConnection() {
        return false;
    }
}

