/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.database;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.shieldcommunity.nullcordx.database.Database;
import net.shieldcommunity.nullcordx.libs.zaxxer.hikari.HikariConfig;
import net.shieldcommunity.nullcordx.libs.zaxxer.hikari.HikariDataSource;

public abstract class ExternalDatabase
implements Database {
    private final String url;
    private final int port;
    private final String database;
    private final String userName;
    private final String password;
    private final List<String> parameters;
    private final int poolSize;
    private final int connectionTimeout;
    private HikariDataSource hikariDataSource = null;
    private ExecutorService executor = null;

    @Override
    public void start() throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.poolSize, new ThreadFactoryBuilder().setNameFormat("NullCordX-" + this.getName() + "-%d").setPriority(3).build());
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.getDriverUrl() + "://" + this.url + ":" + this.port + "/" + this.database + ExternalDatabase.createParameters(this.parameters));
        config.setUsername(this.userName);
        config.setPassword(this.password);
        config.setMaximumPoolSize(this.poolSize);
        config.setConnectionTimeout(this.connectionTimeout);
        this.hikariDataSource = new HikariDataSource(config);
    }

    @Override
    public void stop() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
    }

    @Override
    public Connection getConnection() {
        if (this.hikariDataSource == null) {
            throw new IllegalStateException("Connection pool is null!");
        }
        try {
            return this.hikariDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public boolean needCloseConnection() {
        return true;
    }

    protected abstract String getDriverUrl();

    private static String createParameters(List<String> queries) {
        if (queries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        int start = 1;
        for (String query : queries) {
            if (start > 1) {
                sb.append("&");
            }
            sb.append(query);
            ++start;
        }
        return sb.toString();
    }

    public ExternalDatabase(String url, int port, String database, String userName, String password, List<String> parameters, int poolSize, int connectionTimeout) {
        this.url = url;
        this.port = port;
        this.database = database;
        this.userName = userName;
        this.password = password;
        this.parameters = parameters;
        this.poolSize = poolSize;
        this.connectionTimeout = connectionTimeout;
    }
}

