/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.object.AbstractSerializable;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.reader.AbstractReader;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.reader.YamlReader;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer.AbstractWriter;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.language.writer.YamlWriter;

public class YamlSerializable
extends AbstractSerializable {
    private final Map<Field, YamlWriter.StringStyle> stringStyleMap = new HashMap<Field, YamlWriter.StringStyle>();
    private String singleIndent;

    public YamlSerializable() {
    }

    public YamlSerializable(SerializerConfig config) {
        super(config);
    }

    public YamlSerializable(Path serializablePath, SerializerConfig config) {
        super(serializablePath, config);
    }

    @Override
    protected AbstractReader getReader(BufferedReader reader) {
        return new YamlReader(reader, this.getConfig(), this);
    }

    @Override
    protected AbstractWriter getWriter(BufferedWriter writer) {
        YamlWriter yamlWriter = new YamlWriter(this.getConfig(), writer, this);
        if (this.singleIndent != null) {
            yamlWriter.setSingleIndent(this.singleIndent);
        }
        return yamlWriter;
    }

    public void setSingleIndent(String singleIndent) {
        this.singleIndent = singleIndent;
    }

    public void saveStringStyle(Field field, YamlWriter.StringStyle style) {
        this.stringStyleMap.put(field, style);
    }

    public YamlWriter.StringStyle getStringStyle(Field field) {
        return this.stringStyleMap.get(field);
    }
}

