/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.google.inject.internal;

import jakarta.inject.Provider;
import net.shieldcommunity.nullcordx.libs.google.inject.Key;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ConstructionContext;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.CreationListener;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Errors;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ErrorsException;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InjectorImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalContext;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalProvisionException;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ProviderInternalFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ProvisionListenerStackCallback;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.Dependency;

final class BoundProviderFactory<T>
extends ProviderInternalFactory<T>
implements CreationListener {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injector, Key<? extends Provider<? extends T>> providerKey, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = provisionCallback;
        this.injector = injector;
        this.providerKey = providerKey;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        try {
            Provider<? extends T> provider = this.providerFactory.get(context, dependency, true);
            return this.circularGet(provider, context, dependency, this.provisionCallback);
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(this.providerKey);
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            return super.provision(provider, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw InternalProvisionException.errorInProvider(userException);
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

