/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.maxmind.geoip2.model;

import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.annotation.JacksonInject;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.annotation.JsonCreator;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.annotation.JsonProperty;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.annotation.JsonValue;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.annotation.JsonDeserialize;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.annotation.JsonSerialize;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import net.shieldcommunity.nullcordx.libs.maxmind.db.MaxMindDbConstructor;
import net.shieldcommunity.nullcordx.libs.maxmind.db.MaxMindDbParameter;
import net.shieldcommunity.nullcordx.libs.maxmind.db.Network;
import net.shieldcommunity.nullcordx.libs.maxmind.geoip2.NetworkDeserializer;
import net.shieldcommunity.nullcordx.libs.maxmind.geoip2.model.AbstractResponse;

public class ConnectionTypeResponse
extends AbstractResponse {
    private final ConnectionType connectionType;
    private final String ipAddress;
    private final Network network;

    public ConnectionTypeResponse(@JsonProperty(value="connection_type") ConnectionType connectionType, @JacksonInject(value="ip_address") @JsonProperty(value="ip_address") String ipAddress, @JacksonInject(value="network") @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network) {
        this.connectionType = connectionType;
        this.ipAddress = ipAddress;
        this.network = network;
    }

    @MaxMindDbConstructor
    public ConnectionTypeResponse(@MaxMindDbParameter(name="connection_type") String connectionType, @MaxMindDbParameter(name="ip_address") String ipAddress, @MaxMindDbParameter(name="network") Network network) {
        this(ConnectionType.fromString(connectionType), ipAddress, network);
    }

    public ConnectionTypeResponse(ConnectionTypeResponse response, String ipAddress, Network network) {
        this(response.getConnectionType(), ipAddress, network);
    }

    @JsonProperty(value="connection_type")
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network;
    }

    public static enum ConnectionType {
        DIALUP("Dialup"),
        CABLE_DSL("Cable/DSL"),
        CORPORATE("Corporate"),
        CELLULAR("Cellular"),
        SATELLITE("Satellite");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }

        @JsonCreator
        public static ConnectionType fromString(String s2) {
            if (s2 == null) {
                return null;
            }
            switch (s2) {
                case "Dialup": {
                    return DIALUP;
                }
                case "Cable/DSL": {
                    return CABLE_DSL;
                }
                case "Corporate": {
                    return CORPORATE;
                }
                case "Cellular": {
                    return CELLULAR;
                }
                case "Satellite": {
                    return SATELLITE;
                }
            }
            return null;
        }
    }
}

