/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.io;

import java.io.IOException;
import java.io.PrintStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.io.OutputBitStream;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;

public class DebugOutputBitStream
extends OutputBitStream {
    private final PrintStream pw;
    private final OutputBitStream obs;

    public DebugOutputBitStream(OutputBitStream obs, PrintStream pw) {
        this.obs = obs;
        this.pw = pw;
        pw.print("[");
    }

    public DebugOutputBitStream(OutputBitStream obs) {
        this(obs, System.err);
    }

    @Override
    public void flush() throws IOException {
        this.pw.print(" |");
        this.obs.flush();
    }

    @Override
    public void close() throws IOException {
        this.pw.print(" |]");
        this.obs.close();
    }

    @Override
    public long writtenBits() {
        return this.obs.writtenBits();
    }

    @Override
    public void writtenBits(long writtenBits) {
        this.obs.writtenBits(writtenBits);
    }

    @Override
    public int align() throws IOException {
        this.pw.print(" |");
        return this.obs.align();
    }

    @Override
    public void position(long position) throws IOException {
        this.pw.print(" ->" + position);
        this.obs.position(position);
    }

    static MutableString byte2Binary(int x) {
        MutableString s2 = new MutableString();
        for (int i = 0; i < 8; ++i) {
            s2.append((char)(48 + x % 2));
            x >>= 1;
        }
        return s2.reverse();
    }

    static MutableString int2Binary(long x, int len) {
        MutableString s2 = new MutableString();
        for (int i = 0; i < 64; ++i) {
            s2.append((char)(48L + x % 2L));
            x >>= 1;
        }
        return s2.length(len).reverse();
    }

    @Override
    public long write(byte[] bits, long len) throws IOException {
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        MutableString s2 = new MutableString(" {");
        for (byte bit : bits) {
            s2.append(DebugOutputBitStream.byte2Binary(bit));
        }
        this.pw.print(s2.length((int)len).append("}"));
        return this.obs.write(bits, len);
    }

    @Override
    public int writeBit(boolean bit) throws IOException {
        this.pw.print(" {" + (bit ? (char)'1' : '0') + "}");
        return this.obs.writeBit(bit);
    }

    @Override
    public int writeBit(int bit) throws IOException {
        this.pw.print(" {" + bit + "}");
        return this.obs.writeBit(bit);
    }

    @Override
    public int writeInt(int x, int len) throws IOException {
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + "}");
        return this.obs.writeInt(x, len);
    }

    @Override
    public int writeLong(long x, int len) throws IOException {
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + "}");
        return this.obs.writeLong(x, len);
    }

    @Override
    public int writeUnary(int x) throws IOException {
        this.pw.print(" {U:" + x + "}");
        return this.obs.writeUnary(x);
    }

    @Override
    public long writeLongUnary(long x) throws IOException {
        this.pw.print(" {U:" + x + "}");
        return this.obs.writeLongUnary(x);
    }

    @Override
    public int writeGamma(int x) throws IOException {
        this.pw.print(" {g:" + x + "}");
        return this.obs.writeGamma(x);
    }

    @Override
    public int writeLongGamma(long x) throws IOException {
        this.pw.print(" {g:" + x + "}");
        return this.obs.writeLongGamma(x);
    }

    @Override
    public int writeDelta(int x) throws IOException {
        this.pw.print(" {d:" + x + "}");
        return this.obs.writeDelta(x);
    }

    @Override
    public int writeLongDelta(long x) throws IOException {
        this.pw.print(" {d:" + x + "}");
        return this.obs.writeLongDelta(x);
    }

    @Override
    public int writeMinimalBinary(int x, int b) throws IOException {
        this.pw.print(" {m:" + x + "<" + b + "}");
        return this.obs.writeMinimalBinary(x, b);
    }

    @Override
    public int writeMinimalBinary(int x, int b, int log2b) throws IOException {
        this.pw.print(" {m:" + x + "<" + b + "}");
        return this.obs.writeMinimalBinary(x, b, log2b);
    }

    @Override
    public int writeLongMinimalBinary(long x, long b) throws IOException {
        this.pw.print(" {m:" + x + "<" + b + "}");
        return this.obs.writeLongMinimalBinary(x, b);
    }

    @Override
    public int writeLongMinimalBinary(long x, long b, int log2b) throws IOException {
        this.pw.print(" {m:" + x + "<" + b + "}");
        return this.obs.writeLongMinimalBinary(x, b, log2b);
    }

    @Override
    public int writeGolomb(int x, int b) throws IOException {
        this.pw.print(" {G:" + x + ":" + b + "}");
        return this.obs.writeGolomb(x, b);
    }

    @Override
    public int writeGolomb(int x, int b, int log2b) throws IOException {
        this.pw.print(" {G:" + x + ":" + b + "}");
        return this.obs.writeGolomb(x, b, log2b);
    }

    @Override
    public long writeLongGolomb(long x, long b) throws IOException {
        this.pw.print(" {G:" + x + ":" + b + "}");
        return this.obs.writeLongGolomb(x, b);
    }

    @Override
    public long writeLongGolomb(long x, long b, int log2b) throws IOException {
        this.pw.print(" {G:" + x + ":" + b + "}");
        return this.obs.writeLongGolomb(x, b, log2b);
    }

    @Override
    public int writeSkewedGolomb(int x, int b) throws IOException {
        this.pw.print(" {SG:" + x + ":" + b + "}");
        return this.obs.writeSkewedGolomb(x, b);
    }

    @Override
    public long writeLongSkewedGolomb(long x, long b) throws IOException {
        this.pw.print(" {SG:" + x + ":" + b + "}");
        return this.obs.writeLongSkewedGolomb(x, b);
    }

    @Override
    public int writeZeta(int x, int k) throws IOException {
        this.pw.print(" {z" + k + ":" + x + "}");
        return this.obs.writeZeta(x, k);
    }

    @Override
    public int writeLongZeta(long x, int k) throws IOException {
        this.pw.print(" {z" + k + ":" + x + "}");
        return this.obs.writeLongZeta(x, k);
    }

    @Override
    public int writeNibble(int x) throws IOException {
        this.pw.print(" {N:" + x + "}");
        return this.obs.writeNibble(x);
    }

    @Override
    public int writeLongNibble(long x) throws IOException {
        this.pw.print(" {N:" + x + "}");
        return this.obs.writeLongNibble(x);
    }
}

