/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.logging;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProgressLogger {
    public static final long ONE_SECOND = 1000L;
    public static final long TEN_SECONDS = 10000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long TEN_MINUTES = 600000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long DEFAULT_LOG_INTERVAL = 10000L;
    private static final Pattern[] PLURAL = new Pattern[]{Pattern.compile("s$"), Pattern.compile("(s|si|u)s$"), Pattern.compile("(n)ews$"), Pattern.compile("([ti])a$"), Pattern.compile("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$"), Pattern.compile("(^analy)ses$"), Pattern.compile("(^analy)sis$"), Pattern.compile("([^f])ves$"), Pattern.compile("(hive)s$"), Pattern.compile("(tive)s$"), Pattern.compile("([lr])ves$"), Pattern.compile("([^aeiouy]|qu)ies$"), Pattern.compile("(s)eries$"), Pattern.compile("(m)ovies$"), Pattern.compile("(x|ch|ss|sh)es$"), Pattern.compile("([m|l])ice$"), Pattern.compile("(bus)es$"), Pattern.compile("(o)es$"), Pattern.compile("(shoe)s$"), Pattern.compile("(cris|ax|test)is$"), Pattern.compile("(cris|ax|test)es$"), Pattern.compile("(octop|vir)i$"), Pattern.compile("(octop|vir)us$"), Pattern.compile("(alias|status)es$"), Pattern.compile("(alias|status)$"), Pattern.compile("^(ox)en"), Pattern.compile("(vert|ind)ices$"), Pattern.compile("(matr)ices$"), Pattern.compile("(quiz)zes$"), Pattern.compile("^people$"), Pattern.compile("^men$"), Pattern.compile("^women$"), Pattern.compile("^children$"), Pattern.compile("^sexes$"), Pattern.compile("^moves$"), Pattern.compile("^stadiums$")};
    private static final String[] SINGULAR = new String[]{"", "$1s", "$1ews", "$1um", "$1$2sis", "$1sis", "$1sis", "$1fe", "$1", "$1", "$1f", "$1y", "$1eries", "$1ovie", "$1", "$1ouse", "$1", "$1", "$1", "$1is", "$1is", "$1us", "$1us", "$1", "$1", "$1", "$1ex", "$1ix", "$1", "person", "man", "woman", "child", "sex", "move", "stadium"};
    public final int LIGHT_UPDATE_MASK = 1023;
    public final Logger logger;
    public long logInterval;
    public Object info;
    public long count;
    private long lastCount;
    public long expectedUpdates;
    public String itemsName;
    public boolean displayFreeMemory;
    public boolean displayLocalSpeed;
    public TimeUnit speedTimeUnit;
    public TimeUnit itemTimeUnit;
    private String itemName;
    private String referenceItemsName;
    private long startTime;
    private long stopTime;
    private long lastLogTime;

    public ProgressLogger() {
        this(LoggerFactory.getLogger("ROOT"));
    }

    public ProgressLogger(String itemsName) {
        this(LoggerFactory.getLogger("ROOT"), itemsName);
    }

    public ProgressLogger(Logger logger) {
        this(logger, 10000L, TimeUnit.MILLISECONDS);
    }

    public ProgressLogger(Logger logger, String itemsName) {
        this(logger, 10000L, TimeUnit.MILLISECONDS, itemsName);
    }

    public ProgressLogger(Logger logger, long logInterval, TimeUnit timeUnit) {
        this(logger, logInterval, timeUnit, "items");
    }

    public ProgressLogger(Logger logger, long logInterval, TimeUnit timeUnit, String itemsName) {
        this.logger = logger;
        this.logInterval = timeUnit.toMillis(logInterval);
        this.itemsName = itemsName;
        this.expectedUpdates = -1L;
    }

    public Logger logger() {
        return this.logger;
    }

    private final String itemName() {
        if (this.referenceItemsName == this.itemsName) {
            return this.itemName;
        }
        this.referenceItemsName = this.itemsName;
        int i = PLURAL.length;
        while (i-- != 0) {
            Matcher matcher = PLURAL[i].matcher(this.itemsName);
            if (!matcher.find()) continue;
            this.itemName = matcher.replaceFirst(SINGULAR[i]);
            return this.itemName;
        }
        this.itemName = this.itemsName;
        return this.itemName;
    }

    public void update() {
        this.update(1L);
    }

    public void update(long count) {
        this.count += count;
        long time = System.currentTimeMillis();
        if (time - this.lastLogTime >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void updateAndDisplay() {
        this.updateAndDisplay(1L);
    }

    public void set(long count) {
        this.count = count;
        long time = System.currentTimeMillis();
        if (time - this.lastLogTime >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void setAndDisplay(long count) {
        this.count = count;
        this.updateInternal(System.currentTimeMillis());
    }

    public void updateAndDisplay(long count) {
        this.count += count;
        this.updateInternal(System.currentTimeMillis());
    }

    private String freeMemory() {
        return this.displayFreeMemory ? "; used/avail/free/total/max mem: " + Util.formatSize(Util.RUNTIME.totalMemory() - Util.RUNTIME.freeMemory()) + "/" + Util.formatSize(Util.RUNTIME.freeMemory() + (Util.RUNTIME.maxMemory() - Util.RUNTIME.totalMemory())) + "/" + Util.formatSize(Util.RUNTIME.freeMemory()) + "/" + Util.formatSize(Util.RUNTIME.totalMemory()) + "/" + Util.formatSize(Util.RUNTIME.maxMemory()) : "";
    }

    private String itemsPerTimeInterval(long startCount, long currentTime, long baseTime) {
        double secondsPerItem = (double)(this.count - startCount) * 1000.0 / (double)(currentTime - baseTime);
        if (this.speedTimeUnit == TimeUnit.SECONDS || this.speedTimeUnit == null && secondsPerItem >= 1.0) {
            return Util.format(secondsPerItem) + " " + this.itemsName + "/s";
        }
        if (this.speedTimeUnit == TimeUnit.MINUTES || this.speedTimeUnit == null && secondsPerItem * 60.0 >= 1.0) {
            return Util.format(secondsPerItem * 60.0) + " " + this.itemsName + "/m";
        }
        if (this.speedTimeUnit == TimeUnit.HOURS || this.speedTimeUnit == null && secondsPerItem * 3600.0 >= 1.0) {
            return Util.format(secondsPerItem * 3600.0) + " " + this.itemsName + "/h";
        }
        return Util.format(secondsPerItem * 86400.0) + " " + this.itemsName + "/d";
    }

    private String timePerItem(long startCount, long currentTime, long baseTime) {
        double secondsPerItem = (double)(currentTime - baseTime) / ((double)(this.count - startCount) * 1000.0);
        if (this.itemTimeUnit == null && secondsPerItem >= 86400.0) {
            return Util.format(secondsPerItem / 86400.0) + " d/" + this.itemName();
        }
        if (this.itemTimeUnit == TimeUnit.HOURS || this.itemTimeUnit == null && secondsPerItem >= 3600.0) {
            return Util.format(secondsPerItem / 3600.0) + " h/" + this.itemName();
        }
        if (this.itemTimeUnit == TimeUnit.MINUTES || this.itemTimeUnit == null && secondsPerItem >= 60.0) {
            return Util.format(secondsPerItem / 60.0) + " m/" + this.itemName();
        }
        if (this.itemTimeUnit == TimeUnit.SECONDS || this.itemTimeUnit == null && secondsPerItem >= 1.0) {
            return Util.format(secondsPerItem) + " s/" + this.itemName();
        }
        if (this.itemTimeUnit == TimeUnit.MILLISECONDS || this.itemTimeUnit == null && secondsPerItem >= 0.001) {
            return Util.format(secondsPerItem * 1000.0) + " ms/" + this.itemName();
        }
        if (this.itemTimeUnit == TimeUnit.MICROSECONDS || this.itemTimeUnit == null && secondsPerItem >= 1.0E-6) {
            return Util.format(secondsPerItem * 1000000.0) + " \u00b5s/" + this.itemName();
        }
        return Util.format(secondsPerItem * 1.0E9) + " ns/" + this.itemName();
    }

    private void updateInternal(long currentTime) {
        long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) * ((double)(currentTime - this.startTime) / ((double)this.count + 1.0)));
        if (this.logger().isInfoEnabled()) {
            this.logger().info(Util.format(this.count) + " " + this.itemsName + ", " + this.millis2hms(this.millis()) + ", " + this.itemsPerTimeInterval(0L, currentTime, this.startTime) + ", " + this.timePerItem(0L, currentTime, this.startTime) + (this.displayLocalSpeed ? " [" + this.itemsPerTimeInterval(this.lastCount, currentTime, this.lastLogTime) + ", " + this.timePerItem(this.lastCount, currentTime, this.lastLogTime) + "]" : "") + (this.expectedUpdates > 0L ? "; " + Util.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + this.freeMemory() + (this.info != null ? "; " + this.info : ""));
        }
        this.lastLogTime = currentTime;
        this.lastCount = this.count;
    }

    public final void lightUpdate() {
        long time;
        if ((++this.count & 0x3FFL) == 0L && (time = System.currentTimeMillis()) - this.lastLogTime >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void start() {
        this.start(null, 0L);
    }

    public void start(CharSequence message) {
        this.start(message, 0L);
    }

    public void start(long alreadyElapsed) {
        this.start(null, alreadyElapsed);
    }

    public void start(CharSequence message, long alreadyElapsed) {
        if (message != null) {
            this.logger().info(message.toString());
        }
        this.lastLogTime = System.currentTimeMillis();
        this.startTime = this.lastLogTime - alreadyElapsed;
        this.count = 0L;
        this.lastCount = 0L;
        this.stopTime = -1L;
    }

    public void stop(CharSequence message) {
        if (this.stopTime != -1L) {
            return;
        }
        if (message != null) {
            this.logger().info(message.toString());
        }
        this.stopTime = System.currentTimeMillis();
        this.expectedUpdates = -1L;
    }

    public void stop() {
        this.stop(null);
    }

    public void done() {
        this.stop("Completed.");
        this.logger().info(this.toString());
    }

    public void done(long count) {
        this.count = count;
        this.stop("Completed.");
        this.logger().info(this.toString());
    }

    public long millis() {
        if (this.stopTime != -1L) {
            return this.stopTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    private String millis2hms(long t2) {
        if (t2 < 1000L) {
            return t2 + "ms";
        }
        long s2 = t2 / 1000L % 60L;
        long m4 = t2 / 1000L / 60L % 60L;
        long h2 = t2 / 3600000L;
        if (h2 == 0L && m4 == 0L) {
            return s2 + "s";
        }
        if (h2 == 0L) {
            return m4 + "m " + s2 + "s";
        }
        return h2 + "h " + m4 + "m " + s2 + "s";
    }

    public String toString() {
        long t2 = (this.stopTime != -1L ? this.stopTime : System.currentTimeMillis()) - this.startTime + 1L;
        if (t2 <= 0L) {
            return "Illegal progress logger state";
        }
        return "Elapsed: " + this.millis2hms(t2) + (this.count != 0L ? " [" + Util.format(this.count) + " " + this.itemsName + ", " + this.itemsPerTimeInterval(0L, this.stopTime, this.startTime) + ", " + this.timePerItem(0L, this.stopTime, this.startTime) + "]" : "") + this.freeMemory();
    }
}

