/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.AbstractIntSortedSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntComparator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntIterators;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntListIterator;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.IntSortedSet;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.Intervals;

public final class Interval
extends AbstractIntSortedSet
implements IntSortedSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SINGLE_POINT = 1024;
    private static final Interval[] POINT_INTERVAL = new Interval[1024];
    public final int left;
    public final int right;

    protected Interval(int left, int right) {
        this.left = left;
        this.right = right;
    }

    public static Interval valueOf(int left, int right) {
        if (left > right) {
            throw new IllegalArgumentException("The left extreme (" + left + ") is greater than the right extreme (" + right + ")");
        }
        if (left == right) {
            return Interval.valueOf(left);
        }
        return new Interval(left, right);
    }

    public static Interval valueOf(int point) {
        if (point >= 0 && point < 1024) {
            return POINT_INTERVAL[point];
        }
        return new Interval(point, point);
    }

    public int length() {
        return this.right - this.left + 1;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public IntBidirectionalIterator iterator() {
        if (this == Intervals.EMPTY_INTERVAL) {
            return IntIterators.EMPTY_ITERATOR;
        }
        return IntIterators.fromTo(this.left, this.right + 1);
    }

    public IntBidirectionalIterator iterator(int from) {
        if (this == Intervals.EMPTY_INTERVAL) {
            return IntIterators.EMPTY_ITERATOR;
        }
        IntListIterator i = IntIterators.fromTo(this.left, this.right + 1);
        if (from >= this.left) {
            i.skip(Math.min(this.length(), from + 1 - this.left));
        }
        return i;
    }

    @Override
    public boolean contains(int x) {
        return x >= this.left && x <= this.right;
    }

    public boolean contains(Interval interval) {
        if (interval == Intervals.EMPTY_INTERVAL) {
            return true;
        }
        if (this == Intervals.EMPTY_INTERVAL) {
            return false;
        }
        return this.left <= interval.left && interval.right <= this.right;
    }

    public boolean contains(int x, int radius) {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        return x >= this.left - radius && x <= this.right + radius;
    }

    public boolean contains(int x, int leftRadius, int rightRadius) {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        return x >= this.left - leftRadius && x <= this.right + rightRadius;
    }

    public int compareTo(int x) {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if (x < this.left) {
            return -1;
        }
        if (x > this.right) {
            return 1;
        }
        return 0;
    }

    public int compareTo(int x, int radius) {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if (x < this.left - radius) {
            return -1;
        }
        if (x > this.right + radius) {
            return 1;
        }
        return 0;
    }

    public int compareTo(int x, int leftRadius, int rightRadius) {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new IllegalArgumentException();
        }
        if (x < this.left - leftRadius) {
            return -1;
        }
        if (x > this.right + rightRadius) {
            return 1;
        }
        return 0;
    }

    public IntComparator comparator() {
        return null;
    }

    public IntSortedSet headSet(int to) {
        if (this == Intervals.EMPTY_INTERVAL) {
            return this;
        }
        if (to > this.left) {
            return to > this.right ? this : Interval.valueOf(this.left, to - 1);
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public IntSortedSet tailSet(int from) {
        if (this == Intervals.EMPTY_INTERVAL) {
            return this;
        }
        if (from <= this.right) {
            return from <= this.left ? this : Interval.valueOf(from, this.right);
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public IntSortedSet subSet(int from, int to) {
        if (this == Intervals.EMPTY_INTERVAL) {
            return this;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ")");
        }
        if (to <= this.left || from > this.right || from == to) {
            return Intervals.EMPTY_INTERVAL;
        }
        if (from <= this.left && to > this.right) {
            return this;
        }
        return Interval.valueOf(Math.max(this.left, from), Math.min(this.right, to - 1));
    }

    public int firstInt() {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new NoSuchElementException();
        }
        return this.left;
    }

    public int lastInt() {
        if (this == Intervals.EMPTY_INTERVAL) {
            throw new NoSuchElementException();
        }
        return this.right;
    }

    @Override
    public String toString() {
        if (this == Intervals.EMPTY_INTERVAL) {
            return "\u2205";
        }
        if (this.left == this.right) {
            return "[" + this.left + "]";
        }
        return "[" + this.left + ".." + this.right + "]";
    }

    @Override
    public int hashCode() {
        return this.left * 23 + this.right;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Interval) {
            return ((Interval)o).left == this.left && ((Interval)o).right == this.right;
        }
        if (o instanceof IntSortedSet) {
            IntSortedSet s2 = (IntSortedSet)o;
            if (s2.size() != this.length()) {
                return false;
            }
            int n = this.length();
            IntBidirectionalIterator i = this.iterator();
            IntBidirectionalIterator j = s2.iterator();
            while (n-- != 0) {
                if (i.nextInt() == j.nextInt()) continue;
                return false;
            }
            return true;
        }
        if (o instanceof IntSet) {
            IntSet s3 = (IntSet)o;
            if (s3.size() != this.length()) {
                return false;
            }
            int n = this.length();
            IntBidirectionalIterator i = this.iterator();
            while (n-- != 0) {
                if (s3.contains(i.nextInt())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        int i = 1024;
        while (i-- != 0) {
            Interval.POINT_INTERVAL[i] = new Interval(i, i);
        }
    }
}

