/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.unimi.dsi.util;

import java.io.Serializable;
import java.util.Arrays;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.bits.Fast;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.chars.CharList;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.lang.MutableString;

public class TextPattern
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    public static final int CASE_INSENSITIVE = 1;
    public static final int UNICODE_CASE = 2;
    private static final int PHI2 = 1640531525;
    protected char[] pattern;
    private transient int[] badCharShift;
    private transient int[] asciiBadCharShift = new int[128];
    private transient int mask;
    private transient int hashShift;
    private final boolean caseSensitive;
    private final boolean asciiCase;
    private static final int MIN_COUNT = 8;

    public TextPattern(CharSequence pattern) {
        this(pattern, 0);
    }

    public TextPattern(CharSequence pattern, int flags) {
        this.pattern = new char[pattern.length()];
        MutableString.getChars(pattern, 0, this.pattern.length, this.pattern, 0);
        this.caseSensitive = (flags & 1) == 0;
        boolean bl = this.asciiCase = (flags & 2) == 0;
        if (!this.caseSensitive) {
            int i = this.pattern.length;
            if (this.asciiCase) {
                while (i-- != 0) {
                    this.pattern[i] = TextPattern.asciiToLowerCase(this.pattern[i]);
                }
            } else {
                while (i-- != 0) {
                    this.pattern[i] = TextPattern.unicodeToLowerCase(this.pattern[i]);
                }
            }
        }
        this.compile();
    }

    public boolean caseInsensitive() {
        return !this.caseSensitive;
    }

    public boolean unicodeCase() {
        return !this.asciiCase;
    }

    private static char asciiToLowerCase(char c) {
        return c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
    }

    private static char unicodeToLowerCase(char c) {
        if (c < '\u0080') {
            return c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
        }
        return Character.toLowerCase(Character.toUpperCase(c));
    }

    private void compile() {
        char c;
        char[] p = this.pattern;
        int n = p.length;
        int[] s2 = this.asciiBadCharShift;
        int j = 0;
        int k = 0;
        int[] max = new int[8];
        int i = s2.length;
        while (i-- != 0) {
            s2[i] = n;
        }
        i = 8;
        while (i-- != 0) {
            max[i] = Integer.MAX_VALUE;
        }
        i = n;
        while (i-- != 0) {
            if ((c = p[j++]) < '\u0080') {
                s2[c] = i;
                continue;
            }
            ++k;
            int h2 = c * 1640531525;
            int l = 8;
            while (l-- != 0 && h2 <= max[l]) {
            }
            if (++l >= 8 || h2 == max[l]) continue;
            System.arraycopy(max, l, max, l + 1, 8 - l - 1);
            max[l] = h2;
        }
        int log2m = (k = Math.min(k, (int)(0x800000000L / (0x80000000L + (long)max[7])))) == 0 ? 0 : Math.min(Math.max(Fast.mostSignificantBit(k * 3) + 1, 7), 16);
        int m4 = (1 << log2m) - 1;
        int hs = 16 - log2m;
        s2 = new int[m4 + 1];
        i = m4 + 1;
        while (i-- != 0) {
            s2[i] = n;
        }
        i = n;
        j = 0;
        while (i-- != 0) {
            if ((c = p[j++]) < '\u0080') continue;
            s2[c * c & m4] = i;
            s2[c * 1640531525 >> hs & m4] = i;
        }
        this.badCharShift = s2;
        this.mask = m4;
        this.hashShift = hs;
    }

    @Override
    public int length() {
        return this.pattern.length;
    }

    @Override
    public char charAt(int i) {
        return this.pattern[i];
    }

    @Override
    public CharSequence subSequence(int from, int to) {
        return new MutableString(this.pattern, from, to - from + 1);
    }

    private int indexOf(char[] array, int from, int to) {
        int i;
        char[] a = array;
        char c = this.pattern[0];
        int n = i = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i < to) {
                if (a[i] != c) continue;
                return i;
            }
            return -1;
        }
        if (this.asciiCase) {
            while (++i < to) {
                if (TextPattern.asciiToLowerCase(a[i]) != c) continue;
                return i;
            }
            return -1;
        }
        while (++i < to) {
            if (TextPattern.unicodeToLowerCase(a[i]) != c) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(CharSequence s2, int from, int to) {
        int i;
        char c = this.pattern[0];
        int n = i = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i < to) {
                if (s2.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }
        if (this.asciiCase) {
            while (++i < to) {
                if (TextPattern.asciiToLowerCase(s2.charAt(i)) != c) continue;
                return i;
            }
            return -1;
        }
        while (++i < to) {
            if (TextPattern.unicodeToLowerCase(s2.charAt(i)) != c) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(byte[] array, int from, int to) {
        int i;
        byte[] a = array;
        char c = this.pattern[0];
        int n = i = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i < to) {
                if ((a[i] & 0xFF) != c) continue;
                return i;
            }
            return -1;
        }
        while (++i < to) {
            if (TextPattern.asciiToLowerCase((char)(a[i] & 0xFF)) != c) continue;
            return i;
        }
        return -1;
    }

    public int search(char[] array) {
        return this.search(array, 0, array.length);
    }

    public int search(char[] array, int from) {
        return this.search(array, from, array.length);
    }

    public int search(char[] a, int from, int to) {
        int j;
        int n = this.pattern.length;
        if (n == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return this.indexOf(a, from, to);
        }
        char[] p = this.pattern;
        char last = p[n - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m4 = this.mask;
        int hs = this.hashShift;
        int i = (from < 0 ? 0 : from) + n - 1;
        if (this.caseSensitive) {
            int j2;
            while (i < m1) {
                char c;
                int k;
                if (a[i] == last) {
                    j2 = n - 1;
                    k = i;
                    while (j2-- != 0 && a[--k] == p[j2]) {
                    }
                    if (j2 < 0) {
                        return k;
                    }
                }
                if ((c = a[++i]) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j2 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j2 > k ? j2 : k;
            }
            if (i == m1) {
                j2 = n;
                while (j2-- != 0 && a[i--] == p[j2]) {
                }
                if (j2 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j3;
            while (i < m1) {
                char c;
                int k;
                if (TextPattern.asciiToLowerCase(a[i]) == last) {
                    j3 = n - 1;
                    k = i;
                    while (j3-- != 0 && TextPattern.asciiToLowerCase(a[--k]) == p[j3]) {
                    }
                    if (j3 < 0) {
                        return k;
                    }
                }
                if ((c = TextPattern.asciiToLowerCase(a[++i])) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j3 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j3 > k ? j3 : k;
            }
            if (i == m1) {
                j3 = n;
                while (j3-- != 0 && TextPattern.asciiToLowerCase(a[i--]) == p[j3]) {
                }
                if (j3 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        while (i < m1) {
            char c;
            int k;
            if (TextPattern.unicodeToLowerCase(a[i]) == last) {
                j = n - 1;
                k = i;
                while (j-- != 0 && TextPattern.unicodeToLowerCase(a[--k]) == p[j]) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((c = TextPattern.unicodeToLowerCase(a[++i])) < '\u0080') {
                i += asciiShift[c];
                continue;
            }
            j = shift[c * c & m4];
            k = shift[c * 1640531525 >> hs & m4];
            i += j > k ? j : k;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0 && TextPattern.unicodeToLowerCase(a[i--]) == p[j]) {
            }
            if (j < 0) {
                return i + 1;
            }
        }
        return -1;
    }

    public int search(CharSequence s2) {
        return this.search(s2, 0, s2.length());
    }

    public int search(CharSequence s2, int from) {
        return this.search(s2, from, s2.length());
    }

    public int search(CharSequence s2, int from, int to) {
        int j;
        int n = this.pattern.length;
        if (n == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return this.indexOf(s2, from, to);
        }
        char[] p = this.pattern;
        char last = p[n - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m4 = this.mask;
        int hs = this.hashShift;
        int i = (from < 0 ? 0 : from) + n - 1;
        if (this.caseSensitive) {
            int j2;
            while (i < m1) {
                char c;
                int k;
                if (s2.charAt(i) == last) {
                    j2 = n - 1;
                    k = i;
                    while (j2-- != 0 && s2.charAt(--k) == p[j2]) {
                    }
                    if (j2 < 0) {
                        return k;
                    }
                }
                if ((c = s2.charAt(++i)) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j2 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j2 > k ? j2 : k;
            }
            if (i == m1) {
                j2 = n;
                while (j2-- != 0 && s2.charAt(i--) == p[j2]) {
                }
                if (j2 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j3;
            while (i < m1) {
                char c;
                int k;
                if (TextPattern.asciiToLowerCase(s2.charAt(i)) == last) {
                    j3 = n - 1;
                    k = i;
                    while (j3-- != 0 && TextPattern.asciiToLowerCase(s2.charAt(--k)) == p[j3]) {
                    }
                    if (j3 < 0) {
                        return k;
                    }
                }
                if ((c = TextPattern.asciiToLowerCase(s2.charAt(++i))) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j3 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j3 > k ? j3 : k;
            }
            if (i == m1) {
                j3 = n;
                while (j3-- != 0 && TextPattern.asciiToLowerCase(s2.charAt(i--)) == p[j3]) {
                }
                if (j3 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        while (i < m1) {
            char c;
            int k;
            if (TextPattern.unicodeToLowerCase(s2.charAt(i)) == last) {
                j = n - 1;
                k = i;
                while (j-- != 0 && TextPattern.unicodeToLowerCase(s2.charAt(--k)) == p[j]) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((c = TextPattern.unicodeToLowerCase(s2.charAt(++i))) < '\u0080') {
                i += asciiShift[c];
                continue;
            }
            j = shift[c * c & m4];
            k = shift[c * 1640531525 >> hs & m4];
            i += j > k ? j : k;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0 && TextPattern.unicodeToLowerCase(s2.charAt(i--)) == p[j]) {
            }
            if (j < 0) {
                return i + 1;
            }
        }
        return -1;
    }

    public int search(byte[] a) {
        return this.search(a, 0, a.length);
    }

    public int search(byte[] a, int from) {
        return this.search(a, from, a.length);
    }

    public int search(byte[] a, int from, int to) {
        int j;
        int n = this.pattern.length;
        if (n == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return this.indexOf(a, from, to);
        }
        char[] p = this.pattern;
        char last = p[n - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m4 = this.mask;
        int hs = this.hashShift;
        int i = (from < 0 ? 0 : from) + n - 1;
        if (this.caseSensitive) {
            int j2;
            while (i < m1) {
                char c;
                int k;
                if ((a[i] & 0xFF) == last) {
                    j2 = n - 1;
                    k = i;
                    while (j2-- != 0 && (a[--k] & 0xFF) == p[j2]) {
                    }
                    if (j2 < 0) {
                        return k;
                    }
                }
                if ((c = (char)(a[++i] & 0xFF)) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j2 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j2 > k ? j2 : k;
            }
            if (i == m1) {
                j2 = n;
                while (j2-- != 0 && (a[i--] & 0xFF) == p[j2]) {
                }
                if (j2 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j3;
            while (i < m1) {
                char c;
                int k;
                if (TextPattern.asciiToLowerCase((char)(a[i] & 0xFF)) == last) {
                    j3 = n - 1;
                    k = i;
                    while (j3-- != 0 && TextPattern.asciiToLowerCase((char)(a[--k] & 0xFF)) == p[j3]) {
                    }
                    if (j3 < 0) {
                        return k;
                    }
                }
                if ((c = TextPattern.asciiToLowerCase((char)(a[++i] & 0xFF))) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j3 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j3 > k ? j3 : k;
            }
            if (i == m1) {
                j3 = n;
                while (j3-- != 0 && TextPattern.asciiToLowerCase((char)(a[i--] & 0xFF)) == p[j3]) {
                }
                if (j3 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        while (i < m1) {
            char c;
            int k;
            if (TextPattern.unicodeToLowerCase((char)(a[i] & 0xFF)) == last) {
                j = n - 1;
                k = i;
                while (j-- != 0 && TextPattern.unicodeToLowerCase((char)(a[--k] & 0xFF)) == p[j]) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((c = TextPattern.unicodeToLowerCase((char)(a[++i] & 0xFF))) < '\u0080') {
                i += asciiShift[c];
                continue;
            }
            j = shift[c * c & m4];
            k = shift[c * 1640531525 >> hs & m4];
            i += j > k ? j : k;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0 && TextPattern.unicodeToLowerCase((char)(a[i--] & 0xFF)) == p[j]) {
            }
            if (j < 0) {
                return i + 1;
            }
        }
        return -1;
    }

    public int search(CharList list) {
        return this.search(list, 0, list.size());
    }

    public int search(CharList list, int from) {
        return this.search(list, from, list.size());
    }

    public int search(CharList list, int from, int to) {
        int j;
        int n = this.pattern.length;
        if (n == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return list.subList(from, to).indexOf(this.pattern[0]);
        }
        char[] p = this.pattern;
        char last = p[n - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m4 = this.mask;
        int hs = this.hashShift;
        int i = (from < 0 ? 0 : from) + n - 1;
        if (this.caseSensitive) {
            int j2;
            while (i < m1) {
                char c;
                int k;
                if (list.getChar(i) == last) {
                    j2 = n - 1;
                    k = i;
                    while (j2-- != 0 && list.getChar(--k) == p[j2]) {
                    }
                    if (j2 < 0) {
                        return k;
                    }
                }
                if ((c = list.getChar(++i)) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j2 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j2 > k ? j2 : k;
            }
            if (i == m1) {
                j2 = n;
                while (j2-- != 0 && list.getChar(i--) == p[j2]) {
                }
                if (j2 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j3;
            while (i < m1) {
                char c;
                int k;
                if (TextPattern.asciiToLowerCase(list.getChar(i)) == last) {
                    j3 = n - 1;
                    k = i;
                    while (j3-- != 0 && TextPattern.asciiToLowerCase(list.getChar(--k)) == p[j3]) {
                    }
                    if (j3 < 0) {
                        return k;
                    }
                }
                if ((c = TextPattern.asciiToLowerCase(list.getChar(++i))) < '\u0080') {
                    i += asciiShift[c];
                    continue;
                }
                j3 = shift[c * c & m4];
                k = shift[c * 1640531525 >> hs & m4];
                i += j3 > k ? j3 : k;
            }
            if (i == m1) {
                j3 = n;
                while (j3-- != 0 && TextPattern.asciiToLowerCase(list.getChar(i--)) == p[j3]) {
                }
                if (j3 < 0) {
                    return i + 1;
                }
            }
            return -1;
        }
        while (i < m1) {
            char c;
            int k;
            if (TextPattern.unicodeToLowerCase(list.getChar(i)) == last) {
                j = n - 1;
                k = i;
                while (j-- != 0 && TextPattern.unicodeToLowerCase(list.getChar(--k)) == p[j]) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((c = TextPattern.unicodeToLowerCase(list.getChar(++i))) < '\u0080') {
                i += asciiShift[c];
                continue;
            }
            j = shift[c * c & m4];
            k = shift[c * 1640531525 >> hs & m4];
            i += j > k ? j : k;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0 && TextPattern.unicodeToLowerCase(list.getChar(i--)) == p[j]) {
            }
            if (j < 0) {
                return i + 1;
            }
        }
        return -1;
    }

    public final boolean equals(Object o) {
        if (o instanceof TextPattern) {
            TextPattern p = (TextPattern)o;
            return this.caseSensitive == p.caseSensitive && this.asciiCase == p.asciiCase && Arrays.equals(p.pattern, this.pattern);
        }
        return false;
    }

    public final int hashCode() {
        char[] a = this.pattern;
        int l = a.length;
        int h2 = 0;
        for (int i = 0; i < l; ++i) {
            h2 = 31 * h2 + a[i];
        }
        return h2;
    }

    @Override
    public final String toString() {
        return new String(this.pattern);
    }
}

