/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.natives.CompressionType;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;

public final class Natives {
    private static final CompressorFactory DEFAULT_FACTORY = CompressionType.JAVA.createFactory();
    private static final Set<CompressionType> LOADED_COMPRESSORS = new HashSet<CompressionType>();
    private static CompressorFactory NETWORK_COMPRESSOR_FACTORY = null;
    private static CompressorFactory CACHED_PACKET_COMPRESSOR_FACTORY = null;

    public static CompressorFactory getNetworkCompressorFactory() {
        if (NETWORK_COMPRESSOR_FACTORY == null) {
            return DEFAULT_FACTORY;
        }
        return NETWORK_COMPRESSOR_FACTORY;
    }

    public static CompressorFactory getCachedPacketCompressorFactory() {
        if (CACHED_PACKET_COMPRESSOR_FACTORY == null) {
            return DEFAULT_FACTORY;
        }
        return CACHED_PACKET_COMPRESSOR_FACTORY;
    }

    public static void setupNetworkCompression(CompressionType compressionType, Logger logger) {
        NETWORK_COMPRESSOR_FACTORY = Natives.loadCompression(compressionType);
        logger.log(Level.INFO, "Using " + NETWORK_COMPRESSOR_FACTORY.getName() + " for network compression.");
    }

    public static void setupCachedPacketCompression(CompressionType compressionType, Logger logger) {
        CACHED_PACKET_COMPRESSOR_FACTORY = Natives.loadCompression(compressionType);
        logger.log(Level.INFO, "Using " + CACHED_PACKET_COMPRESSOR_FACTORY.getName() + " for cached packet compression.");
    }

    public static CompressorFactory loadCompression(CompressionType compressionType) {
        CompressorFactory newFactory = compressionType.createFactory();
        String nativePath = newFactory.getNativePath();
        if (nativePath != null && !LOADED_COMPRESSORS.contains((Object)compressionType)) {
            try {
                Natives.copyAndLoadNative(nativePath);
                LOADED_COMPRESSORS.add(compressionType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newFactory;
    }

    private static void copyAndLoadNative(String path) {
        try {
            InputStream nativeLib = Natives.class.getResourceAsStream(path);
            if (nativeLib == null) {
                throw new IllegalStateException("Native library " + path + " not found.");
            }
            Path tempFile = Files.createTempFile("native-", path.substring(path.lastIndexOf(46)), new FileAttribute[0]);
            Files.copy(nativeLib, tempFile, StandardCopyOption.REPLACE_EXISTING);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
            try {
                System.load(tempFile.toAbsolutePath().toString());
            }
            catch (UnsatisfiedLinkError e) {
                throw new RuntimeException("Unable to load native " + tempFile.toAbsolutePath(), e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy natives", e);
        }
    }

    private Natives() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

