/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.igzip;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.natives.compression.jni.NativeIgzipInflate;

public class IgzipDecompressor
implements Decompressor {
    private final long inflateCtx = NativeIgzipInflate.init();
    private boolean closed = false;

    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        Preconditions.checkState(!this.closed, "Decompressor already closed");
        destination.ensureWritable(uncompressedSize);
        long sourceAddress = source.memoryAddress() + (long)source.readerIndex();
        long destinationAddress = destination.memoryAddress() + (long)destination.writerIndex();
        NativeIgzipInflate.process(this.inflateCtx, sourceAddress, source.readableBytes(), destinationAddress, uncompressedSize);
        destination.writerIndex(destination.writerIndex() + uncompressedSize);
    }

    @Override
    public void close() {
        if (!this.closed) {
            NativeIgzipInflate.close(this.inflateCtx);
        }
        this.closed = true;
    }

    @Override
    public boolean isNeedDirectBuffer() {
        return true;
    }
}

