/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.natives.compression.zlib;

import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.natives.compression.zlib.ZlibCompressor;
import net.shieldcommunity.nullcordx.natives.compression.zlib.ZlibDecompressor;

public class ZlibCompressorFactory
implements CompressorFactory {
    private final String name;
    private final String nativePath;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNativePath() {
        return this.nativePath;
    }

    @Override
    public Compressor createCompressor(int level) {
        return new ZlibCompressor(level);
    }

    @Override
    public Decompressor createDecompressor() {
        return new ZlibDecompressor();
    }

    public ZlibCompressorFactory(String name, String nativePath) {
        this.name = name;
        this.nativePath = nativePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZlibCompressorFactory)) {
            return false;
        }
        ZlibCompressorFactory other = (ZlibCompressorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nativePath = this.getNativePath();
        String other$nativePath = other.getNativePath();
        return !(this$nativePath == null ? other$nativePath != null : !this$nativePath.equals(other$nativePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZlibCompressorFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nativePath = this.getNativePath();
        result = result * 59 + ($nativePath == null ? 43 : $nativePath.hashCode());
        return result;
    }

    public String toString() {
        return "ZlibCompressorFactory(name=" + this.getName() + ", nativePath=" + this.getNativePath() + ")";
    }
}

