/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.atomic.LongAdder;
import net.md_5.bungee.BungeeCord;

@ChannelHandler.Sharable
public class ChannelStatisticsDownstreamHandler
extends ChannelDuplexHandler {
    public static final LongAdder OPENED_CONNECTIONS = new LongAdder();

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        OPENED_CONNECTIONS.increment();
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        OPENED_CONNECTIONS.decrement();
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object object) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)object;
            BungeeCord.getInstance().getNullCordX().getStatisticsManager().getDownstreamNetworkStatistics().addChannelReadPerSecond(buf.readableBytes());
        }
        super.channelRead(ctx, object);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object object, ChannelPromise promise) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)object;
            BungeeCord.getInstance().getNullCordX().getStatisticsManager().getDownstreamNetworkStatistics().addChannelWritePerSecond(buf.readableBytes());
        }
        super.write(ctx, object, promise);
    }
}

