/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;

public class MultiBlockUpdatePacket
extends DefinedPacket {
    private int chunkX;
    private int chunkZ;
    private Map<ProtocolPosition, ProtocolBlockType> blocks;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        if (version < 751) {
            buf.writeInt(this.chunkX);
            buf.writeInt(this.chunkZ);
            MultiBlockUpdatePacket.writeVarInt(this.blocks.size(), buf);
            for (Map.Entry<ProtocolPosition, ProtocolBlockType> block : this.blocks.entrySet()) {
                ProtocolPosition position = block.getKey();
                buf.writeShort(position.getX() - (this.chunkX << 4) << 12 | position.getZ() - (this.chunkZ << 4) << 8 | position.getY());
                MultiBlockUpdatePacket.writeVarInt(block.getValue().getIdByProtocol(version), buf);
            }
            return;
        }
        HashMap<ProtocolPosition, ProtocolBlockType> newBlocks = new HashMap<ProtocolPosition, ProtocolBlockType>();
        int chunkY = 0;
        for (Map.Entry<ProtocolPosition, ProtocolBlockType> block : this.blocks.entrySet()) {
            ProtocolPosition position = block.getKey();
            int y = position.getY();
            chunkY = y >> 4;
            newBlocks.put(new ProtocolPosition(position.getX(), y, position.getZ()), block.getValue());
        }
        long chunkPosition = 0L;
        chunkPosition |= ((long)this.chunkX & 0x3FFFFFL) << 42;
        buf.writeLong((chunkPosition |= ((long)this.chunkZ & 0x3FFFFFL) << 20) | (long)chunkY & 0xFFFFFL);
        if (version <= 762) {
            buf.writeBoolean(true);
        }
        MultiBlockUpdatePacket.writeVarInt(this.blocks.size(), buf);
        for (Map.Entry block : newBlocks.entrySet()) {
            ProtocolPosition loc = (ProtocolPosition)block.getKey();
            short position = (short)(loc.getX() - (this.chunkX << 4) << 8 | loc.getZ() - (this.chunkZ << 4) << 4 | loc.getY() - (chunkY << 4));
            MultiBlockUpdatePacket.writeVarLong((long)((ProtocolBlockType)((Object)block.getValue())).getIdByProtocol(version) << 12 | (long)position, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public Map<ProtocolPosition, ProtocolBlockType> getBlocks() {
        return this.blocks;
    }

    public void setChunkX(int chunkX) {
        this.chunkX = chunkX;
    }

    public void setChunkZ(int chunkZ) {
        this.chunkZ = chunkZ;
    }

    public void setBlocks(Map<ProtocolPosition, ProtocolBlockType> blocks) {
        this.blocks = blocks;
    }

    @Override
    public String toString() {
        return "MultiBlockUpdatePacket(chunkX=" + this.getChunkX() + ", chunkZ=" + this.getChunkZ() + ", blocks=" + this.getBlocks() + ")";
    }

    public MultiBlockUpdatePacket() {
    }

    public MultiBlockUpdatePacket(int chunkX, int chunkZ, Map<ProtocolPosition, ProtocolBlockType> blocks) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.blocks = blocks;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiBlockUpdatePacket)) {
            return false;
        }
        MultiBlockUpdatePacket other = (MultiBlockUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkX() != other.getChunkX()) {
            return false;
        }
        if (this.getChunkZ() != other.getChunkZ()) {
            return false;
        }
        Map<ProtocolPosition, ProtocolBlockType> this$blocks = this.getBlocks();
        Map<ProtocolPosition, ProtocolBlockType> other$blocks = other.getBlocks();
        return !(this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiBlockUpdatePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkX();
        result = result * 59 + this.getChunkZ();
        Map<ProtocolPosition, ProtocolBlockType> $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
        return result;
    }
}

