/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class SetExperiencePacket
extends DefinedPacket {
    private float experienceBar;
    private int level;
    private int totalExperience;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeFloat(this.experienceBar);
        DefinedPacket.writeVarInt(this.level, buf);
        DefinedPacket.writeVarInt(this.totalExperience, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public float getExperienceBar() {
        return this.experienceBar;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public void setExperienceBar(float experienceBar) {
        this.experienceBar = experienceBar;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setTotalExperience(int totalExperience) {
        this.totalExperience = totalExperience;
    }

    @Override
    public String toString() {
        return "SetExperiencePacket(experienceBar=" + this.getExperienceBar() + ", level=" + this.getLevel() + ", totalExperience=" + this.getTotalExperience() + ")";
    }

    public SetExperiencePacket() {
    }

    public SetExperiencePacket(float experienceBar, int level, int totalExperience) {
        this.experienceBar = experienceBar;
        this.level = level;
        this.totalExperience = totalExperience;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetExperiencePacket)) {
            return false;
        }
        SetExperiencePacket other = (SetExperiencePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getExperienceBar(), other.getExperienceBar()) != 0) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        return this.getTotalExperience() == other.getTotalExperience();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetExperiencePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getExperienceBar());
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getTotalExperience();
        return result;
    }
}

