/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.protocol.packets;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.protocol.ProtocolEntityType;
import net.shieldcommunity.nullcordx.protocol.ProtocolSpawnEntityData;

public class SpawnEntityPacket
extends DefinedPacket {
    private int entityId;
    private UUID entityUUID;
    private ProtocolEntityType entityType;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;
    private float headYaw;
    private ProtocolSpawnEntityData data;
    private float velocityX;
    private float velocityY;
    private float velocityZ;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        SpawnEntityPacket.writeVarInt(this.entityId, buf);
        if (version > 47) {
            SpawnEntityPacket.writeUUID(this.entityUUID, buf);
        }
        int entityIdType = this.entityType.getEntityIdByProtocol(version);
        if (version > 404) {
            SpawnEntityPacket.writeVarInt(entityIdType, buf);
        } else {
            buf.writeByte(entityIdType);
        }
        if (version > 47) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        } else {
            buf.writeInt((int)(this.x * 32.0));
            buf.writeInt((int)(this.y * 32.0));
            buf.writeInt((int)(this.z * 32.0));
        }
        buf.writeByte((int)(this.pitch * 0.7111111f));
        buf.writeByte((int)(this.yaw * 0.7111111f));
        if (version > 758) {
            buf.writeByte((int)(this.headYaw * 0.7111111f));
        }
        if (version > 758) {
            SpawnEntityPacket.writeVarInt(this.data.getData(version), buf);
        } else {
            buf.writeInt(this.data.getData(version));
        }
        buf.writeShort((int)(this.velocityX * 8000.0f));
        buf.writeShort((int)(this.velocityY * 8000.0f));
        buf.writeShort((int)(this.velocityZ * 8000.0f));
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public ProtocolEntityType getEntityType() {
        return this.entityType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public ProtocolSpawnEntityData getData() {
        return this.data;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public float getVelocityZ() {
        return this.velocityZ;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEntityUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public void setEntityType(ProtocolEntityType entityType) {
        this.entityType = entityType;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setHeadYaw(float headYaw) {
        this.headYaw = headYaw;
    }

    public void setData(ProtocolSpawnEntityData data) {
        this.data = data;
    }

    public void setVelocityX(float velocityX) {
        this.velocityX = velocityX;
    }

    public void setVelocityY(float velocityY) {
        this.velocityY = velocityY;
    }

    public void setVelocityZ(float velocityZ) {
        this.velocityZ = velocityZ;
    }

    @Override
    public String toString() {
        return "SpawnEntityPacket(entityId=" + this.getEntityId() + ", entityUUID=" + this.getEntityUUID() + ", entityType=" + this.getEntityType() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", pitch=" + this.getPitch() + ", yaw=" + this.getYaw() + ", headYaw=" + this.getHeadYaw() + ", data=" + this.getData() + ", velocityX=" + this.getVelocityX() + ", velocityY=" + this.getVelocityY() + ", velocityZ=" + this.getVelocityZ() + ")";
    }

    public SpawnEntityPacket() {
    }

    public SpawnEntityPacket(int entityId, UUID entityUUID, ProtocolEntityType entityType, double x, double y, double z, float pitch, float yaw, float headYaw, ProtocolSpawnEntityData data, float velocityX, float velocityY, float velocityZ) {
        this.entityId = entityId;
        this.entityUUID = entityUUID;
        this.entityType = entityType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.data = data;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpawnEntityPacket)) {
            return false;
        }
        SpawnEntityPacket other = (SpawnEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeadYaw(), other.getHeadYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocityX(), other.getVelocityX()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocityY(), other.getVelocityY()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocityZ(), other.getVelocityZ()) != 0) {
            return false;
        }
        UUID this$entityUUID = this.getEntityUUID();
        UUID other$entityUUID = other.getEntityUUID();
        if (this$entityUUID == null ? other$entityUUID != null : !((Object)this$entityUUID).equals(other$entityUUID)) {
            return false;
        }
        ProtocolEntityType this$entityType = this.getEntityType();
        ProtocolEntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        ProtocolSpawnEntityData this$data = this.getData();
        ProtocolSpawnEntityData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpawnEntityPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getHeadYaw());
        result = result * 59 + Float.floatToIntBits(this.getVelocityX());
        result = result * 59 + Float.floatToIntBits(this.getVelocityY());
        result = result * 59 + Float.floatToIntBits(this.getVelocityZ());
        UUID $entityUUID = this.getEntityUUID();
        result = result * 59 + ($entityUUID == null ? 43 : ((Object)$entityUUID).hashCode());
        ProtocolEntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        ProtocolSpawnEntityData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

