/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.statistics;

import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Event;
import net.shieldcommunity.nullcordx.NullCordXImpl;

public class CountedAttackStatistics {
    private final LongAdder counter = new LongAdder();
    private long maxValueEver = 0L;
    private boolean beforeAttack = false;
    private volatile boolean underAttack = false;
    private volatile long protectionTimestamp = 0L;
    private long checkTimestamp = 0L;
    private final NullCordXImpl nullCordX;
    private final String name;
    private final EventFactory onStartEventFactory;
    private final EventFactory onEndEventFactory;
    private final Runnable onStartTask;
    private final Runnable onEndTask;
    private int threshold = Integer.MAX_VALUE;
    private int protectionTime = Integer.MAX_VALUE;
    private int protectionThresholdTime = Integer.MAX_VALUE;

    public CountedAttackStatistics(NullCordXImpl nullCordX, String name, EventFactory onStartEventFactory, EventFactory onEndEventFactory) {
        this(nullCordX, name, onStartEventFactory, onEndEventFactory, null, null);
    }

    public void load(int threshold, int protectionTime, int protectionThresholdTime) {
        this.threshold = threshold;
        this.protectionTime = protectionTime;
        this.protectionThresholdTime = protectionThresholdTime;
    }

    public long getCounter() {
        return this.counter.sum();
    }

    public void addCounterAndCheckAttack() {
        this.counter.increment();
        if (!this.underAttack && this.counter.sum() >= (long)this.threshold) {
            this.trigger();
        }
    }

    public void handleProtectionCheck() {
        long time = System.currentTimeMillis();
        if (this.underAttack && time - this.protectionTimestamp >= (long)this.protectionTime) {
            long currentCounter = this.counter.sum();
            if (currentCounter >= (long)this.threshold) {
                this.protectionTimestamp = System.currentTimeMillis();
                this.nullCordX.sendDebugLogIfEnabled("We are still under attack in counter " + this.name + ". Count " + currentCounter + " > " + this.threshold);
            } else {
                this.unTrigger();
            }
        }
    }

    public void handleCounter() {
        long time = System.currentTimeMillis();
        if (time - this.checkTimestamp >= (long)this.protectionThresholdTime) {
            long currentValue = this.counter.sum();
            this.nullCordX.sendDebugLogIfEnabled("Resetting " + this.name + " counter. Current value " + currentValue);
            if (currentValue > this.maxValueEver) {
                this.maxValueEver = currentValue;
            }
            this.counter.reset();
            this.checkTimestamp = time;
        }
    }

    public void handleEvent() {
        if (this.underAttack) {
            if (!this.beforeAttack) {
                this.beforeAttack = true;
                this.nullCordX.getLogger().log(Level.WARNING, this.name + " attack detected!");
                if (this.onStartEventFactory != null) {
                    ProxyServer.getInstance().getPluginManager().callEvent(this.onStartEventFactory.createEvent());
                }
                if (this.onStartTask != null) {
                    this.onStartTask.run();
                }
            }
        } else if (this.beforeAttack) {
            this.beforeAttack = false;
            this.nullCordX.getLogger().log(Level.WARNING, "It looks like the " + this.name + " attack has finished.");
            if (this.onEndEventFactory != null) {
                ProxyServer.getInstance().getPluginManager().callEvent(this.onEndEventFactory.createEvent());
            }
            if (this.onEndTask != null) {
                this.onEndTask.run();
            }
        }
    }

    public void trigger() {
        this.underAttack = true;
        this.protectionTimestamp = System.currentTimeMillis();
    }

    public void unTrigger() {
        this.underAttack = false;
        this.protectionTimestamp = 0L;
    }

    public void reset() {
        this.counter.reset();
        this.maxValueEver = 0L;
    }

    public CountedAttackStatistics(NullCordXImpl nullCordX, String name, EventFactory onStartEventFactory, EventFactory onEndEventFactory, Runnable onStartTask, Runnable onEndTask) {
        this.nullCordX = nullCordX;
        this.name = name;
        this.onStartEventFactory = onStartEventFactory;
        this.onEndEventFactory = onEndEventFactory;
        this.onStartTask = onStartTask;
        this.onEndTask = onEndTask;
    }

    public long getMaxValueEver() {
        return this.maxValueEver;
    }

    public boolean isUnderAttack() {
        return this.underAttack;
    }

    public String getName() {
        return this.name;
    }

    public static interface EventFactory {
        public Event createEvent();
    }
}

