/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.nio.charset.StandardCharsets;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.Natives;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;
import net.shieldcommunity.nullcordx.natives.compression.Decompressor;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;

public final class IOUtils {
    private static CompressorThreadLocal compressorThreadLocal = new CompressorThreadLocal(6);
    private static final ByteBufAllocator UNPOOLED_BYTE_BUF_ALLOCATOR = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    private static final ByteBufAllocator POOLED_BYTE_BUF_ALLOCATOR = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public static void setNewCompressorThreadLocal(int compressionLevel) {
        compressorThreadLocal.closeCompressors();
        compressorThreadLocal = new CompressorThreadLocal(compressionLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf compress(ByteBuf in) throws Exception {
        ByteBuf out = IOUtils.getByteBufAllocatorBySettings().directBuffer(in.readableBytes());
        try (Compressor compressor = Natives.getCachedPacketCompressorFactory().createCompressor(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.CACHED_PACKET.LEVEL);){
            ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(IOUtils.getByteBufAllocatorBySettings(), compressor, in);
            try {
                out.writeInt(compatibleIn.readableBytes());
                compressor.deflate(compatibleIn, out);
            }
            finally {
                CachedPacket.releaseByteBufSafe(compatibleIn);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf decompress(ByteBuf in) throws Exception {
        ByteBuf out = IOUtils.getByteBufAllocatorBySettings().directBuffer(in.readableBytes());
        try (Decompressor decompressor = Natives.getCachedPacketCompressorFactory().createDecompressor();){
            ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(IOUtils.getByteBufAllocatorBySettings(), decompressor, in);
            try {
                int uncompressed = compatibleIn.readInt();
                decompressor.inflate(compatibleIn, out, uncompressed);
            }
            finally {
                CachedPacket.releaseByteBufSafe(compatibleIn);
            }
        }
        return out;
    }

    public static void writeByteArray(ByteBuf buf, ByteBuf source) {
        if (source == null) {
            buf.writeInt(0);
            return;
        }
        int size = source.readableBytes();
        buf.writeInt(size);
        buf.writeBytes(source);
    }

    public static void writeByteArray(ByteBuf buf, byte[] source) {
        int size = source.length;
        buf.writeInt(size);
        buf.writeBytes(source);
    }

    public static byte[] readByteArray(ByteBuf buf) {
        int size = buf.readInt();
        byte[] newData = new byte[size];
        for (int i = 0; i < size; ++i) {
            newData[i] = buf.readByte();
        }
        return newData;
    }

    public static void readByteArray(ByteBuf input, ByteBuf output) {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            output.writeByte(input.readByte());
        }
    }

    public static ByteBuf getAndReadByteArray(ByteBuf input) {
        int size = input.readInt();
        if (size == 0) {
            return null;
        }
        ByteBuf newBuf = IOUtils.allocateByteBufBySettings(size);
        for (int i = 0; i < size; ++i) {
            newBuf.writeByte(input.readByte());
        }
        return newBuf;
    }

    public static String readString(ByteBuf out) {
        byte[] bytes = IOUtils.readByteArray(out);
        String string = new String(bytes, StandardCharsets.UTF_8);
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static void writeString(String string, ByteBuf buffer) {
        if (string == null) {
            string = "";
        }
        byte[] answerBytes = string.getBytes(StandardCharsets.UTF_8);
        IOUtils.writeByteArray(buffer, answerBytes);
    }

    public static CompositeByteBuf allocateCompositeByteBufBySettings(int maxSize) {
        return ConfigSettings.IMP.PERFORMANCE.CACHE_PACKETS_IN_DIRECT_MEMORY ? IOUtils.getByteBufAllocatorBySettings().compositeDirectBuffer(maxSize) : IOUtils.getByteBufAllocatorBySettings().compositeHeapBuffer(maxSize);
    }

    public static CompositeByteBuf allocateCompositeByteBufBySettings() {
        return ConfigSettings.IMP.PERFORMANCE.CACHE_PACKETS_IN_DIRECT_MEMORY ? IOUtils.getByteBufAllocatorBySettings().compositeDirectBuffer() : IOUtils.getByteBufAllocatorBySettings().compositeHeapBuffer();
    }

    public static ByteBuf allocateByteBufBySettings(int initialSize, int maxSize) {
        return ConfigSettings.IMP.PERFORMANCE.CACHE_PACKETS_IN_DIRECT_MEMORY ? IOUtils.getByteBufAllocatorBySettings().directBuffer(initialSize, maxSize) : IOUtils.getByteBufAllocatorBySettings().heapBuffer(initialSize, maxSize);
    }

    public static ByteBuf allocateByteBufBySettings(int initialSize) {
        return ConfigSettings.IMP.PERFORMANCE.CACHE_PACKETS_IN_DIRECT_MEMORY ? IOUtils.getByteBufAllocatorBySettings().directBuffer(initialSize) : IOUtils.getByteBufAllocatorBySettings().heapBuffer(initialSize);
    }

    public static ByteBuf allocateByteBufBySettings() {
        return ConfigSettings.IMP.PERFORMANCE.CACHE_PACKETS_IN_DIRECT_MEMORY ? IOUtils.getByteBufAllocatorBySettings().directBuffer() : IOUtils.getByteBufAllocatorBySettings().heapBuffer();
    }

    public static ByteBufAllocator getByteBufAllocatorBySettings() {
        return ConfigSettings.IMP.PERFORMANCE.USE_POOLED_BYTE_BUF_ALLOCATOR_FOR_CACHED_PACKETS ? POOLED_BYTE_BUF_ALLOCATOR : UNPOOLED_BYTE_BUF_ALLOCATOR;
    }

    private IOUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static CompressorThreadLocal getCompressorThreadLocal() {
        return compressorThreadLocal;
    }
}

