/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import net.shieldcommunity.nullcordx.utils.HttpGetWithEntity;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public final class SimpleUpdateChecker {
    private static final URI API_ENTRYPOINT = URI.create("http://47.206.114.248:23446/api/update/check");
    private static final int DEFAULT_TIMEOUT = 15000;
    private static long updateCheckCooldown = 0L;

    public static void startCheckForUpdate(Logger logger) {
        if ((System.currentTimeMillis() - updateCheckCooldown) / 1000L <= 3600L) {
            return;
        }
        updateCheckCooldown = System.currentTimeMillis();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                logger.log(Level.WARNING, ChatColor.GOLD + "Checking for updates...");
                HttpGetWithEntity httpGet = new HttpGetWithEntity(API_ENTRYPOINT);
                httpGet.setEntity(new UrlEncodedFormEntity(Collections.singletonList(new BasicNameValuePair("product", "NullCordX"))));
                try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpGet, 15000);){
                    int code = inputStream.getCode();
                    if (code != 200) {
                        throw new IOException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
                    }
                    String currentVersion = "3.8.4";
                    String latestVersion = inputStream.getTextResponse();
                    if (SimpleUpdateChecker.isUpdateAvailable(currentVersion, latestVersion)) {
                        logger.log(Level.WARNING, ChatColor.GOLD + "############## WARNING ##############");
                        logger.log(Level.WARNING, " ");
                        logger.log(Level.WARNING, ChatColor.GOLD + "You are using an outdated version of NullCordX - " + currentVersion + ".");
                        logger.log(Level.WARNING, ChatColor.GOLD + "Please update your proxy to the latest version - " + latestVersion + "!");
                        logger.log(Level.WARNING, ChatColor.GOLD + "You can download the latest version from BuiltByBit.com or Polymart.org");
                        logger.log(Level.WARNING, " ");
                        logger.log(Level.WARNING, ChatColor.GOLD + "############## WARNING ##############");
                    } else {
                        logger.log(Level.WARNING, ChatColor.GREEN + "You are using the latest version of NullCordX - " + latestVersion + "!");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to check for update", e);
            }
        });
    }

    private static boolean isUpdateAvailable(String currentVersion, String latestVersion) {
        String[] currentVersionParts = currentVersion.split("\\.");
        String[] latestVersionParts = latestVersion.split("\\.");
        for (int i = 0; i < Math.min(currentVersionParts.length, latestVersionParts.length); ++i) {
            int latestPart;
            int currentPart = Integer.parseInt(currentVersionParts[i]);
            if (currentPart < (latestPart = Integer.parseInt(latestVersionParts[i]))) {
                return true;
            }
            if (currentPart <= latestPart) continue;
            return false;
        }
        return currentVersionParts.length < latestVersionParts.length;
    }

    private SimpleUpdateChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

