/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.utils;

import java.io.IOException;
import java.util.zip.Deflater;
import net.shieldcommunity.nullcordx.natives.Natives;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;

public class WrappedCompressors {
    private final int level;
    private Compressor compressor = null;
    private Deflater deflater = null;
    private boolean closed = false;

    public Compressor getCompressor() {
        if (this.closed) {
            throw new IllegalStateException("WrappedCompressor is closed!");
        }
        if (this.compressor == null) {
            this.compressor = Natives.getCachedPacketCompressorFactory().createCompressor(this.level);
        }
        return this.compressor;
    }

    public Deflater getDeflater() {
        if (this.closed) {
            throw new IllegalStateException("WrappedCompressor is closed!");
        }
        if (this.deflater == null) {
            this.deflater = new Deflater(this.level, true);
        }
        return this.deflater;
    }

    public void close() {
        block7: {
            if (this.closed) {
                return;
            }
            try {
                if (this.deflater != null) {
                    this.deflater.end();
                }
                if (this.compressor == null) break block7;
                try {
                    this.compressor.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public WrappedCompressors(int level) {
        this.level = level;
    }
}

