/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.shieldcommunity.nullcordx.libs.google.inject.Injector;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.google.inject.TypeLiteral;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.TypeConverter;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.TypeConverterBinding;
import net.shieldcommunity.nullcordx.libs.javax.inject.Inject;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type) {
        TypeConverter converter = this.converterMap.get(type);
        if (converter == null) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type, converter);
                break;
            }
        }
        return converter;
    }
}

